/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.MagnitudeScoringParameters;
import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import java.io.IOException;
import java.util.ArrayList;

public final class MagnitudeScoringFunction
extends ScoringFunction {
    private String type = "magnitude";
    private final MagnitudeScoringParameters parameters;

    public MagnitudeScoringFunction(String fieldName, double boost, MagnitudeScoringParameters parameters) {
        super(fieldName, boost);
        this.parameters = parameters;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MagnitudeScoringParameters getParameters() {
        return this.parameters;
    }

    @Override
    public MagnitudeScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        super.setInterpolation(interpolation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.getFieldName());
        jsonWriter.writeDoubleField("boost", this.getBoost());
        jsonWriter.writeStringField("interpolation", this.getInterpolation() == null ? null : this.getInterpolation().toString());
        jsonWriter.writeJsonField("magnitude", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MagnitudeScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (MagnitudeScoringFunction)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            ScoringFunctionInterpolation interpolation = null;
            boolean parametersFound = false;
            MagnitudeScoringParameters parameters = null;
            String type = "magnitude";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                    continue;
                }
                if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                    continue;
                }
                if ("magnitude".equals(jsonFieldName)) {
                    parameters = MagnitudeScoringParameters.fromJson(reader);
                    parametersFound = true;
                    continue;
                }
                if ("type".equals(jsonFieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound && boostFound && parametersFound) {
                MagnitudeScoringFunction deserializedMagnitudeScoringFunction = new MagnitudeScoringFunction(fieldName, boost, parameters);
                deserializedMagnitudeScoringFunction.setInterpolation(interpolation);
                deserializedMagnitudeScoringFunction.type = type;
                return deserializedMagnitudeScoringFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }
            if (!parametersFound) {
                missingProperties.add("magnitude");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

