/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class NGramTokenFilterV2
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.NGramTokenFilterV2";
    private Integer minGram;
    private Integer maxGram;

    public NGramTokenFilterV2(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMinGram() {
        return this.minGram;
    }

    public NGramTokenFilterV2 setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    public Integer getMaxGram() {
        return this.maxGram;
    }

    public NGramTokenFilterV2 setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minGram", (Number)this.minGram);
        jsonWriter.writeNumberField("maxGram", (Number)this.maxGram);
        return jsonWriter.writeEndObject();
    }

    public static NGramTokenFilterV2 fromJson(JsonReader jsonReader) throws IOException {
        return (NGramTokenFilterV2)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.NGramTokenFilterV2";
            Integer minGram = null;
            Integer maxGram = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("minGram".equals(fieldName)) {
                    minGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxGram".equals(fieldName)) {
                    maxGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                NGramTokenFilterV2 deserializedNGramTokenFilterV2 = new NGramTokenFilterV2(name);
                deserializedNGramTokenFilterV2.odataType = odataType;
                deserializedNGramTokenFilterV2.minGram = minGram;
                deserializedNGramTokenFilterV2.maxGram = maxGram;
                return deserializedNGramTokenFilterV2;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

