/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.models.SearchRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Objects;

public final class SearchContinuationToken {
    public static final String API_VERSION = "apiVersion";
    public static final String NEXT_LINK = "nextLink";
    public static final String NEXT_PAGE_PARAMETERS = "nextPageParameters";

    private SearchContinuationToken() {
    }

    public static String serializeToken(String apiVersion, String nextLink, SearchRequest nextPageParameters) {
        String string;
        block9: {
            Objects.requireNonNull(apiVersion);
            if (nextLink == null || nextPageParameters == null || nextPageParameters.getSkip() == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonWriter writer = JsonProviders.createWriter((OutputStream)outputStream);
            try {
                writer.writeStartObject().writeStringField(API_VERSION, apiVersion).writeStringField(NEXT_LINK, nextLink).writeJsonField(NEXT_PAGE_PARAMETERS, (JsonSerializable)nextPageParameters).writeEndObject().flush();
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
                if (writer == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            writer.close();
        }
        return string;
    }

    public static SearchRequest deserializeToken(String apiVersion, String continuationToken) {
        SearchRequest searchRequest;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((byte[])Base64.getDecoder().decode(continuationToken));
            try {
                searchRequest = (SearchRequest)jsonReader.readObject(reader -> {
                    String version = null;
                    SearchRequest token = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if (API_VERSION.equals(fieldName)) {
                            version = reader.getString();
                            continue;
                        }
                        if (NEXT_PAGE_PARAMETERS.equals(fieldName)) {
                            token = SearchRequest.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    if (!Objects.equals(apiVersion, version)) {
                        throw new IllegalStateException("Continuation token uses invalid apiVersion" + apiVersion);
                    }
                    return token;
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            jsonReader.close();
        }
        return searchRequest;
    }
}

