/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.StemmerTokenFilterLanguage;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class StemmerTokenFilter
extends TokenFilter {
    private final StemmerTokenFilterLanguage language;

    public StemmerTokenFilter(String name, StemmerTokenFilterLanguage language) {
        super(name);
        this.language = language;
    }

    public StemmerTokenFilterLanguage getLanguage() {
        return this.language;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.StemmerTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("language", Objects.toString((Object)this.language, null));
        return jsonWriter.writeEndObject();
    }

    public static StemmerTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StemmerTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean languageFound = false;
            StemmerTokenFilterLanguage language = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.StemmerTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.StemmerTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("language".equals(fieldName)) {
                    language = StemmerTokenFilterLanguage.fromString(reader.getString());
                    languageFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && languageFound) {
                StemmerTokenFilter deserializedStemmerTokenFilter = new StemmerTokenFilter(name, language);
                return deserializedStemmerTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!languageFound) {
                missingProperties.add("language");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

