/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class SemanticField
implements JsonSerializable<SemanticField> {
    private final String fieldName;

    public SemanticField(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.fieldName);
        return jsonWriter.writeEndObject();
    }

    public static SemanticField fromJson(JsonReader jsonReader) throws IOException {
        return (SemanticField)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound) {
                SemanticField deserializedSemanticField = new SemanticField(fieldName);
                return deserializedSemanticField;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

