/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CognitiveServicesAccount;
import com.azure.search.documents.indexes.models.SearchIndexerKnowledgeStore;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SearchIndexerSkillset
implements JsonSerializable<SearchIndexerSkillset> {
    private final String name;
    private String description;
    private List<SearchIndexerSkill> skills;
    private CognitiveServicesAccount cognitiveServicesAccount;
    private SearchIndexerKnowledgeStore knowledgeStore;
    private String eTag;
    private SearchResourceEncryptionKey encryptionKey;

    public SearchIndexerSkillset(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexerSkillset setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<SearchIndexerSkill> getSkills() {
        return this.skills;
    }

    public SearchIndexerSkillset setSkills(List<SearchIndexerSkill> skills) {
        this.skills = skills;
        return this;
    }

    public CognitiveServicesAccount getCognitiveServicesAccount() {
        return this.cognitiveServicesAccount;
    }

    public SearchIndexerSkillset setCognitiveServicesAccount(CognitiveServicesAccount cognitiveServicesAccount) {
        this.cognitiveServicesAccount = cognitiveServicesAccount;
        return this;
    }

    public SearchIndexerKnowledgeStore getKnowledgeStore() {
        return this.knowledgeStore;
    }

    public SearchIndexerSkillset setKnowledgeStore(SearchIndexerKnowledgeStore knowledgeStore) {
        this.knowledgeStore = knowledgeStore;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndexerSkillset setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SearchIndexerSkillset setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("skills", this.skills, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("cognitiveServices", (JsonSerializable)this.cognitiveServicesAccount);
        jsonWriter.writeJsonField("knowledgeStore", (JsonSerializable)this.knowledgeStore);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerSkillset fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerSkillset)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            List skills = null;
            CognitiveServicesAccount cognitiveServicesAccount = null;
            SearchIndexerKnowledgeStore knowledgeStore = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("skills".equals(fieldName)) {
                    skills = reader.readArray(reader1 -> SearchIndexerSkill.fromJson(reader1));
                    continue;
                }
                if ("cognitiveServices".equals(fieldName)) {
                    cognitiveServicesAccount = CognitiveServicesAccount.fromJson(reader);
                    continue;
                }
                if ("knowledgeStore".equals(fieldName)) {
                    knowledgeStore = SearchIndexerKnowledgeStore.fromJson(reader);
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                SearchIndexerSkillset deserializedSearchIndexerSkillset = new SearchIndexerSkillset(name);
                deserializedSearchIndexerSkillset.description = description;
                deserializedSearchIndexerSkillset.skills = skills;
                deserializedSearchIndexerSkillset.cognitiveServicesAccount = cognitiveServicesAccount;
                deserializedSearchIndexerSkillset.knowledgeStore = knowledgeStore;
                deserializedSearchIndexerSkillset.eTag = eTag;
                deserializedSearchIndexerSkillset.encryptionKey = encryptionKey;
                return deserializedSearchIndexerSkillset;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public SearchIndexerSkillset(String name, List<SearchIndexerSkill> skills) {
        this(name);
        this.skills = skills;
    }

    public SearchIndexerSkillset setSkills(SearchIndexerSkill ... skills) {
        this.skills = skills == null ? null : Arrays.asList(skills);
        return this;
    }
}

