/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.PhoneticEncoder;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class PhoneticTokenFilter
extends TokenFilter {
    private PhoneticEncoder encoder;
    private Boolean originalTokensReplaced;

    public PhoneticTokenFilter(String name) {
        super(name);
    }

    public PhoneticEncoder getEncoder() {
        return this.encoder;
    }

    public PhoneticTokenFilter setEncoder(PhoneticEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public Boolean areOriginalTokensReplaced() {
        return this.originalTokensReplaced;
    }

    public PhoneticTokenFilter setOriginalTokensReplaced(Boolean originalTokensReplaced) {
        this.originalTokensReplaced = originalTokensReplaced;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PhoneticTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("encoder", Objects.toString((Object)this.encoder, null));
        jsonWriter.writeBooleanField("replace", this.originalTokensReplaced);
        return jsonWriter.writeEndObject();
    }

    public static PhoneticTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneticTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            PhoneticEncoder encoder = null;
            Boolean originalTokensReplaced = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.PhoneticTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PhoneticTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("encoder".equals(fieldName)) {
                    encoder = PhoneticEncoder.fromString(reader.getString());
                    continue;
                }
                if ("replace".equals(fieldName)) {
                    originalTokensReplaced = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                PhoneticTokenFilter deserializedPhoneticTokenFilter = new PhoneticTokenFilter(name);
                deserializedPhoneticTokenFilter.encoder = encoder;
                deserializedPhoneticTokenFilter.originalTokensReplaced = originalTokensReplaced;
                return deserializedPhoneticTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

