/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftStemmingTokenizerLanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class MicrosoftLanguageStemmingTokenizer
extends LexicalTokenizer {
    private Integer maxTokenLength;
    private Boolean isSearchTokenizerUsed;
    private MicrosoftStemmingTokenizerLanguage language;

    public MicrosoftLanguageStemmingTokenizer(String name) {
        super(name);
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public MicrosoftLanguageStemmingTokenizer setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    public Boolean isSearchTokenizer() {
        return this.isSearchTokenizerUsed;
    }

    public MicrosoftLanguageStemmingTokenizer setIsSearchTokenizerUsed(Boolean isSearchTokenizerUsed) {
        this.isSearchTokenizerUsed = isSearchTokenizerUsed;
        return this;
    }

    public MicrosoftStemmingTokenizerLanguage getLanguage() {
        return this.language;
    }

    public MicrosoftLanguageStemmingTokenizer setLanguage(MicrosoftStemmingTokenizerLanguage language) {
        this.language = language;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        jsonWriter.writeBooleanField("isSearchTokenizer", this.isSearchTokenizerUsed);
        jsonWriter.writeStringField("language", Objects.toString((Object)this.language, null));
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftLanguageStemmingTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftLanguageStemmingTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer maxTokenLength = null;
            Boolean isSearchTokenizerUsed = null;
            MicrosoftStemmingTokenizerLanguage language = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isSearchTokenizer".equals(fieldName)) {
                    isSearchTokenizerUsed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("language".equals(fieldName)) {
                    language = MicrosoftStemmingTokenizerLanguage.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                MicrosoftLanguageStemmingTokenizer deserializedMicrosoftLanguageStemmingTokenizer = new MicrosoftLanguageStemmingTokenizer(name);
                deserializedMicrosoftLanguageStemmingTokenizer.maxTokenLength = maxTokenLength;
                deserializedMicrosoftLanguageStemmingTokenizer.isSearchTokenizerUsed = isSearchTokenizerUsed;
                deserializedMicrosoftLanguageStemmingTokenizer.language = language;
                return deserializedMicrosoftLanguageStemmingTokenizer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

