/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MergeSkill
extends SearchIndexerSkill {
    private String insertPreTag;
    private String insertPostTag;

    public MergeSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public String getInsertPreTag() {
        return this.insertPreTag;
    }

    public MergeSkill setInsertPreTag(String insertPreTag) {
        this.insertPreTag = insertPreTag;
        return this;
    }

    public String getInsertPostTag() {
        return this.insertPostTag;
    }

    public MergeSkill setInsertPostTag(String insertPostTag) {
        this.insertPostTag = insertPostTag;
        return this;
    }

    @Override
    public MergeSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public MergeSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MergeSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.MergeSkill");
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("insertPreTag", this.insertPreTag);
        jsonWriter.writeStringField("insertPostTag", this.insertPostTag);
        return jsonWriter.writeEndObject();
    }

    public static MergeSkill fromJson(JsonReader jsonReader) throws IOException {
        return (MergeSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String insertPreTag = null;
            String insertPostTag = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Skills.Text.MergeSkill".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.MergeSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("insertPreTag".equals(fieldName)) {
                    insertPreTag = reader.getString();
                    continue;
                }
                if ("insertPostTag".equals(fieldName)) {
                    insertPostTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                MergeSkill deserializedMergeSkill = new MergeSkill(inputs, outputs);
                deserializedMergeSkill.setName(name);
                deserializedMergeSkill.setDescription(description);
                deserializedMergeSkill.setContext(context);
                deserializedMergeSkill.insertPreTag = insertPreTag;
                deserializedMergeSkill.insertPostTag = insertPostTag;
                return deserializedMergeSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

