/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV2;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;

public final class LuceneStandardTokenizer
extends LexicalTokenizer {
    private final LuceneStandardTokenizerV1 v1Tokenizer;
    private final LuceneStandardTokenizerV2 v2tokenizer;

    LuceneStandardTokenizer(LuceneStandardTokenizerV1 v1Tokenizer) {
        super(v1Tokenizer.getName());
        this.v1Tokenizer = v1Tokenizer;
        this.v2tokenizer = null;
    }

    LuceneStandardTokenizer(LuceneStandardTokenizerV2 v2tokenizer) {
        super(v2tokenizer.getName());
        this.v1Tokenizer = null;
        this.v2tokenizer = v2tokenizer;
    }

    public LuceneStandardTokenizer(String name) {
        super(name);
        this.v1Tokenizer = null;
        this.v2tokenizer = new LuceneStandardTokenizerV2(name);
    }

    public Integer getMaxTokenLength() {
        return this.v1Tokenizer != null ? this.v1Tokenizer.getMaxTokenLength() : this.v2tokenizer.getMaxTokenLength();
    }

    public LuceneStandardTokenizer setMaxTokenLength(Integer maxTokenLength) {
        if (this.v1Tokenizer != null) {
            this.v1Tokenizer.setMaxTokenLength(maxTokenLength);
        } else {
            this.v2tokenizer.setMaxTokenLength(maxTokenLength);
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.v1Tokenizer != null ? this.v1Tokenizer.toJson(jsonWriter) : this.v2tokenizer.toJson(jsonWriter);
    }
}

