/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.DistanceScoringParameters;
import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class DistanceScoringFunction
extends ScoringFunction {
    private final DistanceScoringParameters parameters;

    public DistanceScoringFunction(String fieldName, double boost, DistanceScoringParameters parameters) {
        super(fieldName, boost);
        this.parameters = parameters;
    }

    public DistanceScoringParameters getParameters() {
        return this.parameters;
    }

    @Override
    public DistanceScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        super.setInterpolation(interpolation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", "distance");
        jsonWriter.writeStringField("fieldName", this.getFieldName());
        jsonWriter.writeDoubleField("boost", this.getBoost());
        jsonWriter.writeStringField("interpolation", Objects.toString((Object)this.getInterpolation(), null));
        jsonWriter.writeJsonField("distance", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static DistanceScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (DistanceScoringFunction)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            ScoringFunctionInterpolation interpolation = null;
            boolean parametersFound = false;
            DistanceScoringParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(jsonFieldName)) {
                    String type = reader.getString();
                    if ("distance".equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'distance'. The found 'type' was '" + type + "'.");
                }
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                    continue;
                }
                if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                    continue;
                }
                if ("distance".equals(jsonFieldName)) {
                    parameters = DistanceScoringParameters.fromJson(reader);
                    parametersFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound && boostFound && parametersFound) {
                DistanceScoringFunction deserializedDistanceScoringFunction = new DistanceScoringFunction(fieldName, boost, parameters);
                deserializedDistanceScoringFunction.setInterpolation(interpolation);
                return deserializedDistanceScoringFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }
            if (!parametersFound) {
                missingProperties.add("distance");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

