/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SuggestResult
implements JsonSerializable<SuggestResult> {
    private final String text;
    private Map<String, Object> additionalProperties;

    public SuggestResult(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SuggestResult setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SuggestResult fromJson(JsonReader jsonReader) throws IOException {
        return (SuggestResult)jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@search.text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            if (textFound) {
                SuggestResult deserializedSuggestResult = new SuggestResult(text);
                deserializedSuggestResult.additionalProperties = additionalProperties;
                return deserializedSuggestResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!textFound) {
                missingProperties.add("@search.text");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

