/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metrics.models;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.monitor.query.implementation.metrics.models.MetadataValue;
import com.azure.monitor.query.implementation.metrics.models.Metric;
import com.azure.monitor.query.implementation.metrics.models.MetricValue;
import com.azure.monitor.query.implementation.metrics.models.MetricsResponse;
import com.azure.monitor.query.implementation.metrics.models.TimeSeriesElement;
import com.azure.monitor.query.implementation.metricsdefinitions.models.LocalizableString;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricAvailability;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricDefinition;
import com.azure.monitor.query.implementation.metricsnamespaces.models.MetricNamespace;
import com.azure.monitor.query.models.AggregationType;
import com.azure.monitor.query.models.MetricClass;
import com.azure.monitor.query.models.MetricResult;
import com.azure.monitor.query.models.MetricUnit;
import com.azure.monitor.query.models.MetricsQueryResult;
import com.azure.monitor.query.models.NamespaceClassification;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class MetricsHelper {
    private static MetricDefinitionAccessor metricDefinitionAccessor;
    private static MetricAvailabilityAccessor metricAvailabilityAccessor;
    private static MetricNamespaceAccessor metricNamespaceAccessor;

    public static void setMetricDefinitionAccessor(MetricDefinitionAccessor metricDefinitionAccessor) {
        MetricsHelper.metricDefinitionAccessor = metricDefinitionAccessor;
    }

    public static void setMetricAvailabilityAccessor(MetricAvailabilityAccessor metricAvailabilityAccessor) {
        MetricsHelper.metricAvailabilityAccessor = metricAvailabilityAccessor;
    }

    public static void setMetricNamespaceAccessor(MetricNamespaceAccessor metricNamespaceAccessor) {
        MetricsHelper.metricNamespaceAccessor = metricNamespaceAccessor;
    }

    public static void setMetricDefinitionProperties(com.azure.monitor.query.models.MetricDefinition metricDefinition, Boolean dimensionRequired, String resourceId, String namespace, String name, String displayDescription, String category, MetricClass metricClass, MetricUnit unit, AggregationType primaryAggregationType, List<AggregationType> supportedAggregationTypes, List<com.azure.monitor.query.models.MetricAvailability> metricAvailabilities, String id, List<String> dimensions) {
        metricDefinitionAccessor.setMetricDefinitionProperties(metricDefinition, dimensionRequired, resourceId, namespace, name, displayDescription, category, metricClass, unit, primaryAggregationType, supportedAggregationTypes, metricAvailabilities, id, dimensions);
    }

    public static void setMetricAvailabilityProperties(com.azure.monitor.query.models.MetricAvailability metricAvailability, Duration retention, Duration granularity) {
        metricAvailabilityAccessor.setMetricAvailabilityProperties(metricAvailability, retention, granularity);
    }

    public static void setMetricNamespaceProperties(com.azure.monitor.query.models.MetricNamespace metricNamespace, NamespaceClassification classification, String id, String name, String fullyQualifiedName, String type) {
        metricNamespaceAccessor.setMetricNamespaceProperties(metricNamespace, classification, id, name, fullyQualifiedName, type);
    }

    public static Response<MetricsQueryResult> convertToMetricsQueryResult(Response<MetricsResponse> response) {
        MetricsResponse metricsResponse = (MetricsResponse)response.getValue();
        MetricsQueryResult metricsQueryResult = new MetricsQueryResult(metricsResponse.getCost(), metricsResponse.getTimespan() == null ? null : QueryTimeInterval.parse(metricsResponse.getTimespan()), metricsResponse.getInterval(), metricsResponse.getNamespace(), metricsResponse.getResourceregion(), MetricsHelper.mapMetrics(metricsResponse.getValue()));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)metricsQueryResult);
    }

    public static List<MetricResult> mapMetrics(List<Metric> value) {
        return value.stream().map(metric -> {
            MetricUnit metricUnit = metric.getUnit() == null ? null : MetricUnit.fromString(metric.getUnit().toString());
            return new MetricResult(metric.getId(), metric.getType(), metricUnit, metric.getName().getValue(), MetricsHelper.mapTimeSeries(metric.getTimeseries()), metric.getDisplayDescription(), new ResponseError(metric.getErrorCode(), metric.getErrorMessage()));
        }).collect(Collectors.toList());
    }

    public static List<com.azure.monitor.query.models.TimeSeriesElement> mapTimeSeries(List<TimeSeriesElement> timeseries) {
        return timeseries.stream().map(timeSeriesElement -> new com.azure.monitor.query.models.TimeSeriesElement(MetricsHelper.mapMetricsData(timeSeriesElement.getData()), MetricsHelper.mapMetricsMetadata(timeSeriesElement.getMetadatavalues()))).collect(Collectors.toList());
    }

    public static Map<String, String> mapMetricsMetadata(List<MetadataValue> metadataValues) {
        if (metadataValues == null) {
            return null;
        }
        return metadataValues.stream().collect(Collectors.toMap(value -> value.getName().getValue(), MetadataValue::getValue));
    }

    public static List<com.azure.monitor.query.models.MetricValue> mapMetricsData(List<MetricValue> data) {
        return data.stream().map(metricValue -> new com.azure.monitor.query.models.MetricValue(metricValue.getTimeStamp(), metricValue.getAverage(), metricValue.getMinimum(), metricValue.getMaximum(), metricValue.getTotal(), metricValue.getCount())).collect(Collectors.toList());
    }

    public static com.azure.monitor.query.models.MetricNamespace mapMetricNamespace(MetricNamespace namespaceImpl) {
        com.azure.monitor.query.models.MetricNamespace metricNamespace = new com.azure.monitor.query.models.MetricNamespace();
        NamespaceClassification classification = namespaceImpl.getClassification() == null ? null : NamespaceClassification.fromString(namespaceImpl.getClassification().toString());
        MetricsHelper.setMetricNamespaceProperties(metricNamespace, classification, namespaceImpl.getId(), namespaceImpl.getName(), namespaceImpl.getProperties() == null ? null : namespaceImpl.getProperties().getMetricNamespaceName(), namespaceImpl.getType());
        return metricNamespace;
    }

    public static com.azure.monitor.query.models.MetricDefinition mapToMetricDefinition(MetricDefinition definition) {
        com.azure.monitor.query.models.MetricDefinition metricDefinition = new com.azure.monitor.query.models.MetricDefinition();
        List<String> dimensions = null;
        if (!CoreUtils.isNullOrEmpty(definition.getDimensions())) {
            dimensions = definition.getDimensions().stream().map(LocalizableString::getValue).collect(Collectors.toList());
        }
        MetricClass metricClass = definition.getMetricClass() == null ? null : MetricClass.fromString(definition.getMetricClass().toString());
        MetricUnit metricUnit = definition.getUnit() == null ? null : MetricUnit.fromString(definition.getUnit().toString());
        AggregationType primaryAggregationType = definition.getPrimaryAggregationType() == null ? null : AggregationType.fromString(definition.getPrimaryAggregationType().toString());
        List<AggregationType> supportedAggregationTypes = null;
        if (CoreUtils.isNullOrEmpty(definition.getSupportedAggregationTypes())) {
            supportedAggregationTypes = definition.getSupportedAggregationTypes().stream().map(aggregationType -> AggregationType.fromString(aggregationType.toString())).collect(Collectors.toList());
        }
        MetricsHelper.setMetricDefinitionProperties(metricDefinition, definition.isDimensionRequired(), definition.getResourceId(), definition.getNamespace(), definition.getName().getValue(), definition.getDisplayDescription(), definition.getCategory(), metricClass, metricUnit, primaryAggregationType, supportedAggregationTypes, MetricsHelper.mapMetricAvailabilities(definition.getMetricAvailabilities()), definition.getId(), dimensions);
        return metricDefinition;
    }

    private static List<com.azure.monitor.query.models.MetricAvailability> mapMetricAvailabilities(List<MetricAvailability> metricAvailabilities) {
        return metricAvailabilities.stream().map(availabilityImpl -> {
            com.azure.monitor.query.models.MetricAvailability metricAvailability = new com.azure.monitor.query.models.MetricAvailability();
            MetricsHelper.setMetricAvailabilityProperties(metricAvailability, availabilityImpl.getRetention(), availabilityImpl.getTimeGrain());
            return metricAvailability;
        }).collect(Collectors.toList());
    }

    private MetricsHelper() {
    }

    public static interface MetricDefinitionAccessor {
        public void setMetricDefinitionProperties(com.azure.monitor.query.models.MetricDefinition var1, Boolean var2, String var3, String var4, String var5, String var6, String var7, MetricClass var8, MetricUnit var9, AggregationType var10, List<AggregationType> var11, List<com.azure.monitor.query.models.MetricAvailability> var12, String var13, List<String> var14);
    }

    public static interface MetricAvailabilityAccessor {
        public void setMetricAvailabilityProperties(com.azure.monitor.query.models.MetricAvailability var1, Duration var2, Duration var3);
    }

    public static interface MetricNamespaceAccessor {
        public void setMetricNamespaceProperties(com.azure.monitor.query.models.MetricNamespace var1, NamespaceClassification var2, String var3, String var4, String var5, String var6);
    }
}

