// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.metricsnamespaces.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Represents collection of metric namespaces. */
@Immutable
public final class MetricNamespaceCollection {
    /*
     * The values for the metric namespaces.
     */
    @JsonProperty(value = "value", required = true)
    private List<MetricNamespace> value;

    /**
     * Creates an instance of MetricNamespaceCollection class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    public MetricNamespaceCollection(@JsonProperty(value = "value", required = true) List<MetricNamespace> value) {
        this.value = value;
    }

    /**
     * Get the value property: The values for the metric namespaces.
     *
     * @return the value value.
     */
    public List<MetricNamespace> getValue() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getValue() == null) {
            throw new IllegalArgumentException("Missing required property value in model MetricNamespaceCollection");
        } else {
            getValue().forEach(e -> e.validate());
        }
    }
}
