// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A metadata response.
 *
 * <p>The metadata response for the app, including available tables, etc.
 */
@Fluent
public final class MetadataResults {
    /*
     * The list of categories that are referenced in this metadata response.
     */
    @JsonProperty(value = "categories")
    private List<MetadataCategory> categories;

    /*
     * The list of resource types that are referenced in this metadata response.
     */
    @JsonProperty(value = "resourceTypes")
    private List<MetadataResourceType> resourceTypes;

    /*
     * The list of Log Analytics solutions installed on the workspace.
     */
    @JsonProperty(value = "solutions")
    private List<MetadataSolution> solutions;

    /*
     * The list of tables and columns that comprise the schema of the workspace.
     */
    @JsonProperty(value = "tables")
    private List<MetadataTable> tables;

    /*
     * The list of functions stored on the workspace, or introduced by solutions etc.
     */
    @JsonProperty(value = "functions")
    private List<MetadataFunction> functions;

    /*
     * The list of saved queries stored on the workspace, or introduced by solutions, resource types, etc.
     */
    @JsonProperty(value = "queries")
    private List<MetadataQuery> queries;

    /*
     * The list of Application Insights apps that were referenced in the metadata request.
     */
    @JsonProperty(value = "applications")
    private List<MetadataApplication> applications;

    /*
     * The list of Log Analytics workspaces that were referenced in the metadata request.
     */
    @JsonProperty(value = "workspaces")
    private List<MetadataWorkspace> workspaces;

    /*
     * The list of Azure resources that were referenced in the metadata request.
     */
    @JsonProperty(value = "resources")
    private List<Object> resources;

    /*
     * The list of permission rules that affected the metadata request.
     */
    @JsonProperty(value = "permissions")
    private List<MetadataPermissions> permissions;

    /** Creates an instance of MetadataResults class. */
    public MetadataResults() {}

    /**
     * Get the categories property: The list of categories that are referenced in this metadata response.
     *
     * @return the categories value.
     */
    public List<MetadataCategory> getCategories() {
        return this.categories;
    }

    /**
     * Set the categories property: The list of categories that are referenced in this metadata response.
     *
     * @param categories the categories value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setCategories(List<MetadataCategory> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the resourceTypes property: The list of resource types that are referenced in this metadata response.
     *
     * @return the resourceTypes value.
     */
    public List<MetadataResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The list of resource types that are referenced in this metadata response.
     *
     * @param resourceTypes the resourceTypes value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setResourceTypes(List<MetadataResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the solutions property: The list of Log Analytics solutions installed on the workspace.
     *
     * @return the solutions value.
     */
    public List<MetadataSolution> getSolutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: The list of Log Analytics solutions installed on the workspace.
     *
     * @param solutions the solutions value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setSolutions(List<MetadataSolution> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Get the tables property: The list of tables and columns that comprise the schema of the workspace.
     *
     * @return the tables value.
     */
    public List<MetadataTable> getTables() {
        return this.tables;
    }

    /**
     * Set the tables property: The list of tables and columns that comprise the schema of the workspace.
     *
     * @param tables the tables value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setTables(List<MetadataTable> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the functions property: The list of functions stored on the workspace, or introduced by solutions etc.
     *
     * @return the functions value.
     */
    public List<MetadataFunction> getFunctions() {
        return this.functions;
    }

    /**
     * Set the functions property: The list of functions stored on the workspace, or introduced by solutions etc.
     *
     * @param functions the functions value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setFunctions(List<MetadataFunction> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Get the queries property: The list of saved queries stored on the workspace, or introduced by solutions, resource
     * types, etc.
     *
     * @return the queries value.
     */
    public List<MetadataQuery> getQueries() {
        return this.queries;
    }

    /**
     * Set the queries property: The list of saved queries stored on the workspace, or introduced by solutions, resource
     * types, etc.
     *
     * @param queries the queries value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setQueries(List<MetadataQuery> queries) {
        this.queries = queries;
        return this;
    }

    /**
     * Get the applications property: The list of Application Insights apps that were referenced in the metadata
     * request.
     *
     * @return the applications value.
     */
    public List<MetadataApplication> getApplications() {
        return this.applications;
    }

    /**
     * Set the applications property: The list of Application Insights apps that were referenced in the metadata
     * request.
     *
     * @param applications the applications value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setApplications(List<MetadataApplication> applications) {
        this.applications = applications;
        return this;
    }

    /**
     * Get the workspaces property: The list of Log Analytics workspaces that were referenced in the metadata request.
     *
     * @return the workspaces value.
     */
    public List<MetadataWorkspace> getWorkspaces() {
        return this.workspaces;
    }

    /**
     * Set the workspaces property: The list of Log Analytics workspaces that were referenced in the metadata request.
     *
     * @param workspaces the workspaces value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setWorkspaces(List<MetadataWorkspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    /**
     * Get the resources property: The list of Azure resources that were referenced in the metadata request.
     *
     * @return the resources value.
     */
    public List<Object> getResources() {
        return this.resources;
    }

    /**
     * Set the resources property: The list of Azure resources that were referenced in the metadata request.
     *
     * @param resources the resources value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setResources(List<Object> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the permissions property: The list of permission rules that affected the metadata request.
     *
     * @return the permissions value.
     */
    public List<MetadataPermissions> getPermissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: The list of permission rules that affected the metadata request.
     *
     * @param permissions the permissions value to set.
     * @return the MetadataResults object itself.
     */
    public MetadataResults setPermissions(List<MetadataPermissions> permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getCategories() != null) {
            getCategories().forEach(e -> e.validate());
        }
        if (getResourceTypes() != null) {
            getResourceTypes().forEach(e -> e.validate());
        }
        if (getSolutions() != null) {
            getSolutions().forEach(e -> e.validate());
        }
        if (getTables() != null) {
            getTables().forEach(e -> e.validate());
        }
        if (getFunctions() != null) {
            getFunctions().forEach(e -> e.validate());
        }
        if (getQueries() != null) {
            getQueries().forEach(e -> e.validate());
        }
        if (getApplications() != null) {
            getApplications().forEach(e -> e.validate());
        }
        if (getWorkspaces() != null) {
            getWorkspaces().forEach(e -> e.validate());
        }
        if (getPermissions() != null) {
            getPermissions().forEach(e -> e.validate());
        }
    }
}
