// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A query response for a single query in a batch.
 *
 * <p>Contains the tables, columns &amp; rows resulting from a query.
 */
@Fluent
public final class BatchQueryResults {
    /*
     * The list of tables, columns and rows.
     */
    @JsonProperty(value = "tables")
    private List<Table> tables;

    /*
     * Statistics represented in JSON format.
     */
    @JsonProperty(value = "statistics")
    private Object statistics;

    /*
     * Visualization data in JSON format.
     */
    @JsonProperty(value = "render")
    private Object render;

    /*
     * The code and message for an error.
     */
    @JsonProperty(value = "error")
    private ErrorInfo error;

    /** Creates an instance of BatchQueryResults class. */
    public BatchQueryResults() {}

    /**
     * Get the tables property: The list of tables, columns and rows.
     *
     * @return the tables value.
     */
    public List<Table> getTables() {
        return this.tables;
    }

    /**
     * Set the tables property: The list of tables, columns and rows.
     *
     * @param tables the tables value to set.
     * @return the BatchQueryResults object itself.
     */
    public BatchQueryResults setTables(List<Table> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the statistics property: Statistics represented in JSON format.
     *
     * @return the statistics value.
     */
    public Object getStatistics() {
        return this.statistics;
    }

    /**
     * Set the statistics property: Statistics represented in JSON format.
     *
     * @param statistics the statistics value to set.
     * @return the BatchQueryResults object itself.
     */
    public BatchQueryResults setStatistics(Object statistics) {
        this.statistics = statistics;
        return this;
    }

    /**
     * Get the render property: Visualization data in JSON format.
     *
     * @return the render value.
     */
    public Object getRender() {
        return this.render;
    }

    /**
     * Set the render property: Visualization data in JSON format.
     *
     * @param render the render value to set.
     * @return the BatchQueryResults object itself.
     */
    public BatchQueryResults setRender(Object render) {
        this.render = render;
        return this;
    }

    /**
     * Get the error property: The code and message for an error.
     *
     * @return the error value.
     */
    public ErrorInfo getError() {
        return this.error;
    }

    /**
     * Set the error property: The code and message for an error.
     *
     * @param error the error value to set.
     * @return the BatchQueryResults object itself.
     */
    public BatchQueryResults setError(ErrorInfo error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getTables() != null) {
            getTables().forEach(e -> e.validate());
        }
        if (getError() != null) {
            getError().validate();
        }
    }
}
