// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** An single request in a batch. */
@Fluent
public final class BatchQueryRequest {
    /*
     * The error details.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * Dictionary of <string>
     */
    @JsonProperty(value = "headers")
    private Map<String, String> headers;

    /*
     * The Analytics query. Learn more about the [Analytics query
     * syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/)
     */
    @JsonProperty(value = "body", required = true)
    private QueryBody body;

    /*
     * The path property.
     */
    @JsonProperty(value = "path")
    private String path = "/query";

    /*
     * The method property.
     */
    @JsonProperty(value = "method")
    private String method = "POST";

    /*
     * Workspace Id to be included in the query
     */
    @JsonProperty(value = "workspace", required = true)
    private String workspace;

    /**
     * Creates an instance of BatchQueryRequest class.
     *
     * @param id the id value to set.
     * @param body the body value to set.
     * @param workspace the workspace value to set.
     */
    @JsonCreator
    public BatchQueryRequest(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "body", required = true) QueryBody body,
            @JsonProperty(value = "workspace", required = true) String workspace) {
        path = "/query";
        method = "POST";
        this.id = id;
        this.body = body;
        this.workspace = workspace;
    }

    /**
     * Get the id property: The error details.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the headers property: Dictionary of &lt;string&gt;.
     *
     * @return the headers value.
     */
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    /**
     * Set the headers property: Dictionary of &lt;string&gt;.
     *
     * @param headers the headers value to set.
     * @return the BatchQueryRequest object itself.
     */
    public BatchQueryRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the body property: The Analytics query. Learn more about the [Analytics query
     * syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/).
     *
     * @return the body value.
     */
    public QueryBody getBody() {
        return this.body;
    }

    /**
     * Get the path property: The path property.
     *
     * @return the path value.
     */
    public String getPath() {
        return this.path;
    }

    /**
     * Set the path property: The path property.
     *
     * @param path the path value to set.
     * @return the BatchQueryRequest object itself.
     */
    public BatchQueryRequest setPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the method property: The method property.
     *
     * @return the method value.
     */
    public String getMethod() {
        return this.method;
    }

    /**
     * Set the method property: The method property.
     *
     * @param method the method value to set.
     * @return the BatchQueryRequest object itself.
     */
    public BatchQueryRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Get the workspace property: Workspace Id to be included in the query.
     *
     * @return the workspace value.
     */
    public String getWorkspace() {
        return this.workspace;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getId() == null) {
            throw new IllegalArgumentException("Missing required property id in model BatchQueryRequest");
        }
        if (getBody() == null) {
            throw new IllegalArgumentException("Missing required property body in model BatchQueryRequest");
        } else {
            getBody().validate();
        }
        if (getWorkspace() == null) {
            throw new IllegalArgumentException("Missing required property workspace in model BatchQueryRequest");
        }
    }
}
