// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.query.implementation.logs.models.ErrorResponseException;
import com.azure.monitor.query.implementation.logs.models.MetadataResults;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Metadatas. */
public final class MetadatasImpl {
    /** The proxy service used to perform REST calls. */
    private final MetadatasService service;

    /** The service client containing this operation class. */
    private final AzureLogAnalyticsImpl client;

    /**
     * Initializes an instance of Metadatas.
     *
     * @param client the instance of the service client containing this operation class.
     */
    MetadatasImpl(AzureLogAnalyticsImpl client) {
        this.service =
                RestProxy.create(MetadatasService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureLogAnalyticsMetadatas to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AzureLogAnalyticsMet")
    public interface MetadatasService {
        @Get("/workspaces/{workspaceId}/metadata")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<MetadataResults>> get(
                @HostParam("$host") String host,
                @PathParam("workspaceId") String workspaceId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/workspaces/{workspaceId}/metadata")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<MetadataResults> getSync(
                @HostParam("$host") String host,
                @PathParam("workspaceId") String workspaceId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/workspaces/{workspaceId}/metadata")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<MetadataResults>> post(
                @HostParam("$host") String host,
                @PathParam("workspaceId") String workspaceId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/workspaces/{workspaceId}/metadata")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<MetadataResults> postSync(
                @HostParam("$host") String host,
                @PathParam("workspaceId") String workspaceId,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> getWithResponseAsync(String workspaceId) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.get(this.client.getHost(), workspaceId, accept, context));
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> getWithResponseAsync(String workspaceId, Context context) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        final String accept = "application/json";
        return service.get(this.client.getHost(), workspaceId, accept, context);
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetadataResults> getAsync(String workspaceId) {
        return getWithResponseAsync(workspaceId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetadataResults> getAsync(String workspaceId, Context context) {
        return getWithResponseAsync(workspaceId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MetadataResults> getWithResponse(String workspaceId, Context context) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        final String accept = "application/json";
        return service.getSync(this.client.getHost(), workspaceId, accept, context);
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MetadataResults get(String workspaceId) {
        return getWithResponse(workspaceId, Context.NONE).getValue();
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> postWithResponseAsync(String workspaceId) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.post(this.client.getHost(), workspaceId, accept, context));
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> postWithResponseAsync(String workspaceId, Context context) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        final String accept = "application/json";
        return service.post(this.client.getHost(), workspaceId, accept, context);
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetadataResults> postAsync(String workspaceId) {
        return postWithResponseAsync(workspaceId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetadataResults> postAsync(String workspaceId, Context context) {
        return postWithResponseAsync(workspaceId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MetadataResults> postWithResponse(String workspaceId, Context context) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        final String accept = "application/json";
        return service.postSync(this.client.getHost(), workspaceId, accept, context);
    }

    /**
     * Gets metadata information
     *
     * <p>Retrieve the metadata information for the workspace, including its schema, functions, workspace info,
     * categories etc.
     *
     * @param workspaceId ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metadata response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MetadataResults post(String workspaceId) {
        return postWithResponse(workspaceId, Context.NONE).getValue();
    }
}
