// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** The MessageCountDetails model. */
@JacksonXmlRootElement(
        localName = "CountDetails",
        namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
@Fluent
public final class MessageCountDetails {
    /*
     * Number of active messages in the queue, topic, or subscription.
     */
    @JacksonXmlProperty(
            localName = "ActiveMessageCount",
            namespace = "http://schemas.microsoft.com/netservices/2011/06/servicebus")
    private Integer activeMessageCount;

    /*
     * Number of messages that are dead lettered.
     */
    @JacksonXmlProperty(
            localName = "DeadLetterMessageCount",
            namespace = "http://schemas.microsoft.com/netservices/2011/06/servicebus")
    private Integer deadLetterMessageCount;

    /*
     * Number of scheduled messages.
     */
    @JacksonXmlProperty(
            localName = "ScheduledMessageCount",
            namespace = "http://schemas.microsoft.com/netservices/2011/06/servicebus")
    private Integer scheduledMessageCount;

    /*
     * Number of messages transferred into dead letters.
     */
    @JacksonXmlProperty(
            localName = "TransferDeadLetterMessageCount",
            namespace = "http://schemas.microsoft.com/netservices/2011/06/servicebus")
    private Integer transferDeadLetterMessageCount;

    /*
     * Number of messages transferred to another queue, topic, or subscription.
     */
    @JacksonXmlProperty(
            localName = "TransferMessageCount",
            namespace = "http://schemas.microsoft.com/netservices/2011/06/servicebus")
    private Integer transferMessageCount;

    /**
     * Get the activeMessageCount property: Number of active messages in the queue, topic, or subscription.
     *
     * @return the activeMessageCount value.
     */
    public Integer getActiveMessageCount() {
        return this.activeMessageCount;
    }

    /**
     * Set the activeMessageCount property: Number of active messages in the queue, topic, or subscription.
     *
     * @param activeMessageCount the activeMessageCount value to set.
     * @return the MessageCountDetails object itself.
     */
    public MessageCountDetails setActiveMessageCount(Integer activeMessageCount) {
        this.activeMessageCount = activeMessageCount;
        return this;
    }

    /**
     * Get the deadLetterMessageCount property: Number of messages that are dead lettered.
     *
     * @return the deadLetterMessageCount value.
     */
    public Integer getDeadLetterMessageCount() {
        return this.deadLetterMessageCount;
    }

    /**
     * Set the deadLetterMessageCount property: Number of messages that are dead lettered.
     *
     * @param deadLetterMessageCount the deadLetterMessageCount value to set.
     * @return the MessageCountDetails object itself.
     */
    public MessageCountDetails setDeadLetterMessageCount(Integer deadLetterMessageCount) {
        this.deadLetterMessageCount = deadLetterMessageCount;
        return this;
    }

    /**
     * Get the scheduledMessageCount property: Number of scheduled messages.
     *
     * @return the scheduledMessageCount value.
     */
    public Integer getScheduledMessageCount() {
        return this.scheduledMessageCount;
    }

    /**
     * Set the scheduledMessageCount property: Number of scheduled messages.
     *
     * @param scheduledMessageCount the scheduledMessageCount value to set.
     * @return the MessageCountDetails object itself.
     */
    public MessageCountDetails setScheduledMessageCount(Integer scheduledMessageCount) {
        this.scheduledMessageCount = scheduledMessageCount;
        return this;
    }

    /**
     * Get the transferDeadLetterMessageCount property: Number of messages transferred into dead letters.
     *
     * @return the transferDeadLetterMessageCount value.
     */
    public Integer getTransferDeadLetterMessageCount() {
        return this.transferDeadLetterMessageCount;
    }

    /**
     * Set the transferDeadLetterMessageCount property: Number of messages transferred into dead letters.
     *
     * @param transferDeadLetterMessageCount the transferDeadLetterMessageCount value to set.
     * @return the MessageCountDetails object itself.
     */
    public MessageCountDetails setTransferDeadLetterMessageCount(Integer transferDeadLetterMessageCount) {
        this.transferDeadLetterMessageCount = transferDeadLetterMessageCount;
        return this;
    }

    /**
     * Get the transferMessageCount property: Number of messages transferred to another queue, topic, or subscription.
     *
     * @return the transferMessageCount value.
     */
    public Integer getTransferMessageCount() {
        return this.transferMessageCount;
    }

    /**
     * Set the transferMessageCount property: Number of messages transferred to another queue, topic, or subscription.
     *
     * @param transferMessageCount the transferMessageCount value to set.
     * @return the MessageCountDetails object itself.
     */
    public MessageCountDetails setTransferMessageCount(Integer transferMessageCount) {
        this.transferMessageCount = transferMessageCount;
        return this;
    }
}
