/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.models.MessagingSku;
import com.azure.messaging.servicebus.administration.models.NamespaceType;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class NamespaceProperties
implements XmlSerializable<NamespaceProperties> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private String alias;
    private OffsetDateTime createdTime;
    private MessagingSku messagingSku;
    private Integer messagingUnits;
    private OffsetDateTime modifiedTime;
    private String name;
    private NamespaceType namespaceType;

    public String getAlias() {
        return this.alias;
    }

    public NamespaceProperties setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    NamespaceProperties setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public MessagingSku getMessagingSku() {
        return this.messagingSku;
    }

    public NamespaceProperties setMessagingSku(MessagingSku messagingSku) {
        this.messagingSku = messagingSku;
        return this;
    }

    public Integer getMessagingUnits() {
        return this.messagingUnits;
    }

    public NamespaceProperties setMessagingUnits(Integer messagingUnits) {
        this.messagingUnits = messagingUnits;
        return this;
    }

    public OffsetDateTime getModifiedTime() {
        return this.modifiedTime;
    }

    public NamespaceProperties setModifiedTime(OffsetDateTime modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NamespaceProperties setName(String name) {
        this.name = name;
        return this;
    }

    public NamespaceType getNamespaceType() {
        return this.namespaceType;
    }

    public NamespaceProperties setNamespaceType(NamespaceType namespaceType) {
        this.namespaceType = namespaceType;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "NamespaceInfo" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Alias", this.alias);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedTime", this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessagingSKU", this.messagingSku == null ? null : this.messagingSku.toString());
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessagingUnits", (Number)this.messagingUnits);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ModifiedTime", this.modifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.modifiedTime));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Name", this.name);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "NamespaceType", this.namespaceType == null ? null : this.namespaceType.toString());
        return xmlWriter.writeEndElement();
    }

    public static NamespaceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return NamespaceProperties.fromXml(xmlReader, null);
    }

    public static NamespaceProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "NamespaceInfo" : rootElementName;
        return (NamespaceProperties)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            NamespaceProperties deserializedNamespaceProperties = new NamespaceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Alias".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.alias = reader.getStringElement();
                    continue;
                }
                if ("CreatedTime".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.createdTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("MessagingSKU".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.messagingSku = MessagingSku.fromString(reader.getStringElement());
                    continue;
                }
                if ("MessagingUnits".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.messagingUnits = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ModifiedTime".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.modifiedTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("Name".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.name = reader.getStringElement();
                    continue;
                }
                if ("NamespaceType".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespaceProperties.namespaceType = NamespaceType.fromString(reader.getStringElement());
                    continue;
                }
                reader.skipElement();
            }
            return deserializedNamespaceProperties;
        });
    }
}

