/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.ServiceBusMessageContext;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.SessionsMessagePump;
import com.azure.messaging.servicebus.models.AbandonOptions;
import com.azure.messaging.servicebus.models.CompleteOptions;
import com.azure.messaging.servicebus.models.DeadLetterOptions;
import com.azure.messaging.servicebus.models.DeferOptions;
import java.util.Objects;

public final class ServiceBusReceivedMessageContext {
    private final ServiceBusMessageContext receivedMessageContext;
    private final ServiceBusReceiverAsyncClient receiverClient;
    private final SessionsMessagePump.SessionReceiversTracker sessionReceivers;
    private final String fullyQualifiedNamespace;
    private final String entityPath;

    ServiceBusReceivedMessageContext(ServiceBusReceiverAsyncClient receiverClient, ServiceBusMessageContext receivedMessageContext) {
        this.receivedMessageContext = Objects.requireNonNull(receivedMessageContext, "'receivedMessageContext' cannot be null");
        this.receiverClient = Objects.requireNonNull(receiverClient, "'receiverClient' cannot be null");
        this.sessionReceivers = null;
        this.entityPath = receiverClient.getEntityPath();
        this.fullyQualifiedNamespace = receiverClient.getFullyQualifiedNamespace();
    }

    ServiceBusReceivedMessageContext(SessionsMessagePump.SessionReceiversTracker sessionReceivers, ServiceBusMessageContext receivedMessageContext) {
        this.receivedMessageContext = receivedMessageContext;
        this.sessionReceivers = sessionReceivers;
        this.receiverClient = null;
        this.entityPath = sessionReceivers.getEntityPath();
        this.fullyQualifiedNamespace = sessionReceivers.getFullyQualifiedNamespace();
    }

    public ServiceBusReceivedMessage getMessage() {
        return this.receivedMessageContext.getMessage();
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public void abandon() {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.abandon(this.receivedMessageContext.getMessage()).block();
            return;
        }
        this.receiverClient.abandon(this.receivedMessageContext.getMessage()).block();
    }

    public void abandon(AbandonOptions options) {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.abandon(this.receivedMessageContext.getMessage(), options).block();
            return;
        }
        this.receiverClient.abandon(this.receivedMessageContext.getMessage(), options).block();
    }

    public void complete() {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.complete(this.receivedMessageContext.getMessage()).block();
            return;
        }
        this.receiverClient.complete(this.receivedMessageContext.getMessage()).block();
    }

    public void complete(CompleteOptions options) {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.complete(this.receivedMessageContext.getMessage(), options).block();
            return;
        }
        this.receiverClient.complete(this.receivedMessageContext.getMessage(), options).block();
    }

    public void defer() {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.defer(this.receivedMessageContext.getMessage()).block();
            return;
        }
        this.receiverClient.defer(this.receivedMessageContext.getMessage()).block();
    }

    public void defer(DeferOptions options) {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.defer(this.receivedMessageContext.getMessage(), options).block();
            return;
        }
        this.receiverClient.defer(this.receivedMessageContext.getMessage(), options).block();
    }

    public void deadLetter() {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.deadLetter(this.receivedMessageContext.getMessage()).block();
            return;
        }
        this.receiverClient.deadLetter(this.receivedMessageContext.getMessage()).block();
    }

    public void deadLetter(DeadLetterOptions options) {
        if (this.sessionReceivers != null) {
            this.sessionReceivers.deadLetter(this.receivedMessageContext.getMessage(), options).block();
            return;
        }
        this.receiverClient.deadLetter(this.receivedMessageContext.getMessage(), options).block();
    }
}

