/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.IterableStream;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.models.CreateBatchOptions;
import com.azure.messaging.eventhubs.models.SendOptions;
import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;

public class EventHubProducerClient
implements Closeable {
    private final EventHubProducerAsyncClient producer;
    private final Duration tryTimeout;

    EventHubProducerClient(EventHubProducerAsyncClient producer, Duration tryTimeout) {
        this.producer = Objects.requireNonNull(producer, "'producer' cannot be null.");
        this.tryTimeout = Objects.requireNonNull(tryTimeout, "'tryTimeout' cannot be null.");
    }

    public String getEventHubName() {
        return this.producer.getEventHubName();
    }

    public String getFullyQualifiedNamespace() {
        return this.producer.getFullyQualifiedNamespace();
    }

    public EventHubProperties getEventHubProperties() {
        return (EventHubProperties)this.producer.getEventHubProperties().block(this.tryTimeout);
    }

    public IterableStream<String> getPartitionIds() {
        return new IterableStream(this.producer.getPartitionIds());
    }

    public PartitionProperties getPartitionProperties(String partitionId) {
        return (PartitionProperties)this.producer.getPartitionProperties(partitionId).block(this.tryTimeout);
    }

    public EventDataBatch createBatch() {
        return (EventDataBatch)this.producer.createBatch().block(this.tryTimeout);
    }

    public EventDataBatch createBatch(CreateBatchOptions options) {
        return (EventDataBatch)this.producer.createBatch(options).block(this.tryTimeout);
    }

    void send(EventData event) {
        this.producer.send(event).block();
    }

    void send(EventData event, SendOptions options) {
        this.producer.send(event, options).block();
    }

    public void send(Iterable<EventData> events) {
        this.producer.send(events).block();
    }

    public void send(Iterable<EventData> events, SendOptions options) {
        this.producer.send(events, options).block();
    }

    public void send(EventDataBatch batch) {
        this.producer.send(batch).block();
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

