/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.util.IterableStream;
import com.azure.messaging.eventhubs.EventHubAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.PartitionProperties;
import java.io.Closeable;
import java.util.Objects;

class EventHubClient
implements Closeable {
    private final EventHubAsyncClient client;
    private final AmqpRetryOptions retry;

    EventHubClient(EventHubAsyncClient client, AmqpRetryOptions retry) {
        this.client = Objects.requireNonNull(client, "'client' cannot be null.");
        this.retry = retry;
    }

    EventHubProperties getProperties() {
        return (EventHubProperties)this.client.getProperties().block(this.retry.getTryTimeout());
    }

    IterableStream<String> getPartitionIds() {
        return new IterableStream(this.client.getPartitionIds());
    }

    PartitionProperties getPartitionProperties(String partitionId) {
        return (PartitionProperties)this.client.getPartitionProperties(partitionId).block(this.retry.getTryTimeout());
    }

    EventHubProducerClient createProducer() {
        EventHubProducerAsyncClient producer = this.client.createProducer();
        return new EventHubProducerClient(producer, this.retry.getTryTimeout());
    }

    EventHubConsumerClient createConsumer(String consumerGroup, int prefetchCount) {
        EventHubConsumerAsyncClient consumer = this.client.createConsumer(consumerGroup, prefetchCount);
        return new EventHubConsumerClient(consumer, this.retry.getTryTimeout());
    }

    @Override
    public void close() {
        this.client.close();
    }
}

