/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.checkpointstore.blob;

import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.metrics.MeterProvider;
import com.azure.messaging.eventhubs.models.Checkpoint;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

final class MetricsHelper {
    private static final ClientLogger LOGGER = new ClientLogger(MetricsHelper.class);
    private static final String ENTITY_NAME_KEY = "entityName";
    private static final String HOSTNAME_KEY = "hostName";
    private static final String PARTITION_ID_KEY = "partitionId";
    private static final String CONSUMER_GROUP_KEY = "consumerGroup";
    private static final String STATUS_KEY = "status";
    private static final int MAX_ATTRIBUTES_SETS = 100;
    private static final String PROPERTIES_FILE = "azure-messaging-eventhubs-checkpointstore-blob.properties";
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String LIBRARY_NAME;
    private static final String LIBRARY_VERSION;
    private static final String UNKNOWN = "UNKNOWN";
    private final ConcurrentHashMap<String, TelemetryAttributes> common = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TelemetryAttributes> checkpointFailure = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TelemetryAttributes> checkpointSuccess = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CurrentValue> seqNoSubscriptions = new ConcurrentHashMap();
    private volatile boolean maxCapacityReached = false;
    private final Meter meter;
    private final LongGauge lastSequenceNumber;
    private final DoubleHistogram checkpointDuration;
    private final boolean isEnabled;

    MetricsHelper(MetricsOptions metricsOptions, MeterProvider meterProvider) {
        if (MetricsHelper.areMetricsEnabled(metricsOptions)) {
            this.meter = meterProvider.createMeter(LIBRARY_NAME, LIBRARY_VERSION, metricsOptions);
            this.isEnabled = this.meter.isEnabled();
        } else {
            this.meter = null;
            this.isEnabled = false;
        }
        if (this.isEnabled) {
            this.lastSequenceNumber = this.meter.createLongGauge("messaging.eventhubs.checkpoint.sequence_number", "Last successfully checkpointed sequence number.", "seqNo");
            this.checkpointDuration = this.meter.createDoubleHistogram("messaging.eventhubs.checkpoint.duration", "Duration of checkpoint call.", "ms");
        } else {
            this.lastSequenceNumber = null;
            this.checkpointDuration = null;
        }
    }

    boolean isCheckpointDurationEnabled() {
        return this.isEnabled && this.checkpointDuration.isEnabled();
    }

    void reportCheckpoint(Checkpoint checkpoint, String attributesId, boolean success, Instant startTime) {
        TelemetryAttributes attributes;
        if (!(this.isEnabled && this.lastSequenceNumber.isEnabled() && this.checkpointDuration.isEnabled())) {
            return;
        }
        if (!(this.maxCapacityReached || this.seqNoSubscriptions.size() < 100 && this.common.size() < 100)) {
            LOGGER.error("Too many attribute combinations are reported for checkpoint metrics, ignoring any new dimensions.");
            this.maxCapacityReached = true;
        }
        if (this.lastSequenceNumber.isEnabled() && success) {
            this.updateCurrentValue(attributesId, checkpoint);
        }
        if (this.checkpointDuration.isEnabled() && (attributes = success ? this.getOrCreate(this.checkpointSuccess, attributesId, checkpoint, null) : this.getOrCreate(this.checkpointFailure, attributesId, checkpoint, "error")) != null && this.checkpointDuration.isEnabled()) {
            this.checkpointDuration.record((double)Duration.between(startTime, Instant.now()).toMillis(), attributes, Context.NONE);
        }
    }

    private TelemetryAttributes getOrCreate(ConcurrentHashMap<String, TelemetryAttributes> source, String attributesId, Checkpoint checkpoint, String status) {
        if (this.maxCapacityReached) {
            return source.get(attributesId);
        }
        return source.computeIfAbsent(attributesId, i -> this.meter.createAttributes(this.createAttributes(checkpoint, status)));
    }

    private Map<String, Object> createAttributes(Checkpoint checkpoint, String status) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>(5);
        attributesMap.put(HOSTNAME_KEY, checkpoint.getFullyQualifiedNamespace());
        attributesMap.put(ENTITY_NAME_KEY, checkpoint.getEventHubName());
        attributesMap.put(PARTITION_ID_KEY, checkpoint.getPartitionId());
        attributesMap.put(CONSUMER_GROUP_KEY, checkpoint.getConsumerGroup());
        if (status != null) {
            attributesMap.put(STATUS_KEY, status);
        }
        return attributesMap;
    }

    private void updateCurrentValue(String attributesId, Checkpoint checkpoint) {
        CurrentValue valueSupplier;
        if (checkpoint.getSequenceNumber() == null) {
            return;
        }
        if (this.maxCapacityReached) {
            valueSupplier = this.seqNoSubscriptions.get(attributesId);
            if (valueSupplier == null) {
                return;
            }
        } else {
            TelemetryAttributes attributes = this.getOrCreate(this.common, attributesId, checkpoint, null);
            if (attributes == null) {
                return;
            }
            valueSupplier = this.seqNoSubscriptions.computeIfAbsent(attributesId, a -> {
                AtomicReference<Long> lastSeqNo = new AtomicReference<Long>();
                return new CurrentValue(this.lastSequenceNumber.registerCallback(() -> (Long)lastSeqNo.get(), attributes), lastSeqNo);
            });
        }
        valueSupplier.set(checkpoint.getSequenceNumber());
    }

    private static boolean areMetricsEnabled(MetricsOptions options) {
        return options == null || options.isEnabled();
    }

    static {
        Map properties = CoreUtils.getProperties((String)PROPERTIES_FILE);
        LIBRARY_NAME = properties.getOrDefault(NAME_KEY, UNKNOWN);
        LIBRARY_VERSION = properties.getOrDefault(VERSION_KEY, UNKNOWN);
    }

    private static class CurrentValue {
        private final AtomicReference<Long> lastSeqNo;
        private final AutoCloseable subscription;

        CurrentValue(AutoCloseable subscription, AtomicReference<Long> lastSeqNo) {
            this.subscription = subscription;
            this.lastSeqNo = lastSeqNo;
        }

        void set(long value) {
            this.lastSeqNo.set(value);
        }

        void close() {
            if (this.subscription != null) {
                try {
                    this.subscription.close();
                }
                catch (Exception e) {
                    throw (RuntimeException)LOGGER.logThrowableAsWarning((Throwable)new RuntimeException(e));
                }
            }
        }
    }
}

