/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterLabelOperator;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerSelectorState;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public final class AcsRouterWorkerSelector
implements JsonSerializable<AcsRouterWorkerSelector> {
    private String key;
    private AcsRouterLabelOperator labelOperator;
    private Object labelValue;
    private Float ttlSeconds;
    private AcsRouterWorkerSelectorState state;
    private OffsetDateTime expirationTime;

    public String getKey() {
        return this.key;
    }

    public AcsRouterWorkerSelector setKey(String key) {
        this.key = key;
        return this;
    }

    public AcsRouterLabelOperator getLabelOperator() {
        return this.labelOperator;
    }

    public AcsRouterWorkerSelector setLabelOperator(AcsRouterLabelOperator labelOperator) {
        this.labelOperator = labelOperator;
        return this;
    }

    public Object getLabelValue() {
        return this.labelValue;
    }

    public AcsRouterWorkerSelector setLabelValue(Object labelValue) {
        this.labelValue = labelValue;
        return this;
    }

    public Duration getTimeToLive() {
        return this.ttlSeconds == null ? null : Duration.ofSeconds(this.ttlSeconds.longValue());
    }

    public AcsRouterWorkerSelector setTimeToLive(Duration timeToLive) {
        if (timeToLive != null) {
            this.ttlSeconds = Float.valueOf(timeToLive.getSeconds());
        }
        return this;
    }

    public AcsRouterWorkerSelectorState getState() {
        return this.state;
    }

    public AcsRouterWorkerSelector setState(AcsRouterWorkerSelectorState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public AcsRouterWorkerSelector setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("labelOperator", this.labelOperator == null ? null : this.labelOperator.toString());
        if (this.labelValue != null) {
            jsonWriter.writeUntypedField("value", this.labelValue);
        }
        jsonWriter.writeNumberField("ttlSeconds", (Number)this.ttlSeconds);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("expirationTime", this.expirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTime));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterWorkerSelector fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterWorkerSelector)jsonReader.readObject(reader -> {
            AcsRouterWorkerSelector deserializedAcsRouterWorkerSelector = new AcsRouterWorkerSelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedAcsRouterWorkerSelector.key = reader.getString();
                    continue;
                }
                if ("labelOperator".equals(fieldName)) {
                    deserializedAcsRouterWorkerSelector.labelOperator = AcsRouterLabelOperator.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedAcsRouterWorkerSelector.labelValue = reader.readUntyped();
                    continue;
                }
                if ("ttlSeconds".equals(fieldName)) {
                    deserializedAcsRouterWorkerSelector.ttlSeconds = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAcsRouterWorkerSelector.state = AcsRouterWorkerSelectorState.fromString(reader.getString());
                    continue;
                }
                if ("expirationTime".equals(fieldName)) {
                    deserializedAcsRouterWorkerSelector.expirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterWorkerSelector;
        });
    }
}

