// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.iot.deviceupdate.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.iot.deviceupdate.DeviceUpdateServiceVersion;

/** Initializes a new instance of the DeviceUpdateClient type. */
public final class DeviceUpdateClientImpl {
    /** The Device Update for IoT Hub account endpoint (hostname only, no protocol). */
    private final String endpoint;

    /**
     * Gets The Device Update for IoT Hub account endpoint (hostname only, no protocol).
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** The Device Update for IoT Hub account instance identifier. */
    private final String instanceId;

    /**
     * Gets The Device Update for IoT Hub account instance identifier.
     *
     * @return the instanceId value.
     */
    public String getInstanceId() {
        return this.instanceId;
    }

    /** Service version. */
    private final DeviceUpdateServiceVersion serviceVersion;

    /**
     * Gets Service version.
     *
     * @return the serviceVersion value.
     */
    public DeviceUpdateServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The DeviceUpdatesImpl object to access its operations. */
    private final DeviceUpdatesImpl deviceUpdates;

    /**
     * Gets the DeviceUpdatesImpl object to access its operations.
     *
     * @return the DeviceUpdatesImpl object.
     */
    public DeviceUpdatesImpl getDeviceUpdates() {
        return this.deviceUpdates;
    }

    /** The DeviceManagementsImpl object to access its operations. */
    private final DeviceManagementsImpl deviceManagements;

    /**
     * Gets the DeviceManagementsImpl object to access its operations.
     *
     * @return the DeviceManagementsImpl object.
     */
    public DeviceManagementsImpl getDeviceManagements() {
        return this.deviceManagements;
    }

    /**
     * Initializes an instance of DeviceUpdateClient client.
     *
     * @param endpoint The Device Update for IoT Hub account endpoint (hostname only, no protocol).
     * @param instanceId The Device Update for IoT Hub account instance identifier.
     * @param serviceVersion Service version.
     */
    public DeviceUpdateClientImpl(String endpoint, String instanceId, DeviceUpdateServiceVersion serviceVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                endpoint,
                instanceId,
                serviceVersion);
    }

    /**
     * Initializes an instance of DeviceUpdateClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint The Device Update for IoT Hub account endpoint (hostname only, no protocol).
     * @param instanceId The Device Update for IoT Hub account instance identifier.
     * @param serviceVersion Service version.
     */
    public DeviceUpdateClientImpl(
            HttpPipeline httpPipeline, String endpoint, String instanceId, DeviceUpdateServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, instanceId, serviceVersion);
    }

    /**
     * Initializes an instance of DeviceUpdateClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint The Device Update for IoT Hub account endpoint (hostname only, no protocol).
     * @param instanceId The Device Update for IoT Hub account instance identifier.
     * @param serviceVersion Service version.
     */
    public DeviceUpdateClientImpl(
            HttpPipeline httpPipeline,
            SerializerAdapter serializerAdapter,
            String endpoint,
            String instanceId,
            DeviceUpdateServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.instanceId = instanceId;
        this.serviceVersion = serviceVersion;
        this.deviceUpdates = new DeviceUpdatesImpl(this);
        this.deviceManagements = new DeviceManagementsImpl(this);
    }
}
