/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class TablesInsertEntityHeaders {
    private String xMsVersion;
    private String eTag;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private String preferenceApplied;
    private String contentType;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");

    public TablesInsertEntityHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.preferenceApplied = rawHeaders.getValue(HttpHeaderName.PREFERENCE_APPLIED);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public TablesInsertEntityHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public TablesInsertEntityHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public TablesInsertEntityHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public TablesInsertEntityHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public TablesInsertEntityHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getPreferenceApplied() {
        return this.preferenceApplied;
    }

    public TablesInsertEntityHeaders setPreferenceApplied(String preferenceApplied) {
        this.preferenceApplied = preferenceApplied;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public TablesInsertEntityHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

