/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.IterableStream;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.azure.data.tables.models.TableEntity;
import java.util.List;

public class EntityPaged<T extends TableEntity>
implements PagedResponse<T> {
    private static final String DELIMITER_CONTINUATION_TOKEN = ";";
    private final Response<TableEntityQueryResponse> httpResponse;
    private final IterableStream<T> entityStream;
    private final String continuationToken;

    public EntityPaged(Response<TableEntityQueryResponse> httpResponse, List<T> entityList, String nextPartitionKey, String nextRowKey) {
        this.continuationToken = nextPartitionKey == null ? null : (nextRowKey == null ? nextPartitionKey : String.join((CharSequence)DELIMITER_CONTINUATION_TOKEN, nextPartitionKey, nextRowKey));
        this.httpResponse = httpResponse;
        this.entityStream = IterableStream.of(entityList);
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusCode();
    }

    public HttpHeaders getHeaders() {
        return this.httpResponse.getHeaders();
    }

    public HttpRequest getRequest() {
        return this.httpResponse.getRequest();
    }

    public IterableStream<T> getElements() {
        return this.entityStream;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void close() {
    }
}

