/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemaGroups;
import reactor.core.publisher.Mono;

public final class SchemaGroupsOperationsImpl {
    private final SchemaGroupsService service;
    private final AzureSchemaRegistryImpl client;

    SchemaGroupsOperationsImpl(AzureSchemaRegistryImpl client) {
        this.service = (SchemaGroupsService)RestProxy.create(SchemaGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaGroups>> listWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="AzureSchemaRegistryS")
    private static interface SchemaGroupsService {
        @Get(value="/$schemaGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<SchemaGroups>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

