// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.schemaregistry.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemaGroups;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SchemaGroupsOperations. */
public final class SchemaGroupsOperationsImpl {
    /** The proxy service used to perform REST calls. */
    private final SchemaGroupsService service;

    /** The service client containing this operation class. */
    private final AzureSchemaRegistryImpl client;

    /**
     * Initializes an instance of SchemaGroupsOperationsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    SchemaGroupsOperationsImpl(AzureSchemaRegistryImpl client) {
        this.service =
                RestProxy.create(SchemaGroupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureSchemaRegistrySchemaGroupsOperations to be used by the proxy
     * service to perform REST calls.
     */
    @Host("https://{endpoint}")
    @ServiceInterface(name = "AzureSchemaRegistryS")
    private interface SchemaGroupsService {
        @Get("/$schemaGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<SchemaGroups>> list(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Gets the list of schema groups user is authorized to access.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of schema groups user is authorized to access.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SchemaGroups>> listWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.list(this.client.getEndpoint(), this.client.getApiVersion(), accept, context);
    }
}
