/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.models.SchemaFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import reactor.core.publisher.Mono;

class SchemaRegistrySchemaCache {
    private static final String SIZE_KEY = "size";
    private static final String TOTAL_LENGTH_KEY = "totalLength";
    private final ClientLogger logger = new ClientLogger(SchemaRegistrySchemaCache.class);
    private final SchemaCache cache;
    private final SchemaRegistryAsyncClient schemaRegistryClient;
    private final String schemaGroup;
    private final boolean autoRegisterSchemas;
    private final Object lock = new Object();

    SchemaRegistrySchemaCache(SchemaRegistryAsyncClient schemaRegistryClient, String schemaGroup, boolean autoRegisterSchemas, int capacity) {
        this.schemaRegistryClient = schemaRegistryClient;
        this.schemaGroup = schemaGroup;
        this.autoRegisterSchemas = autoRegisterSchemas;
        this.cache = new SchemaCache(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mono<String> getSchemaId(Schema schema) {
        String existingSchemaId;
        Object object = this.lock;
        synchronized (object) {
            existingSchemaId = this.cache.getSchemaId(schema);
        }
        if (existingSchemaId != null) {
            return Mono.just((Object)existingSchemaId);
        }
        String schemaFullName = schema.getFullName();
        String schemaString = schema.toString();
        if (CoreUtils.isNullOrEmpty((CharSequence)this.schemaGroup)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalStateException("Cannot serialize when 'schemaGroup' is not set. Pleaseset in SchemaRegistryApacheAvroSerializer.schemaGroup when creating serializer."));
        }
        Mono serviceCall = this.autoRegisterSchemas ? this.schemaRegistryClient.registerSchema(this.schemaGroup, schemaFullName, schemaString, SchemaFormat.AVRO) : this.schemaRegistryClient.getSchemaProperties(this.schemaGroup, schemaFullName, schemaString, SchemaFormat.AVRO);
        return serviceCall.map(properties -> {
            String schemaId = properties.getId();
            Object object = this.lock;
            synchronized (object) {
                this.cache.put(schemaId, schema);
                this.logCacheStatus();
            }
            return schemaId;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mono<Schema> getSchema(String schemaId) {
        Object object = this.lock;
        synchronized (object) {
            Schema existing = (Schema)this.cache.get(schemaId);
            if (existing != null) {
                return Mono.just((Object)existing);
            }
        }
        return this.schemaRegistryClient.getSchema(schemaId).handle((registryObject, sink) -> {
            Schema parsedSchema;
            String schemaString = registryObject.getDefinition();
            Object object = this.lock;
            synchronized (object) {
                parsedSchema = new Schema.Parser().parse(schemaString);
                this.cache.put(schemaId, parsedSchema);
                this.logCacheStatus();
            }
            sink.next((Object)parsedSchema);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTotalLength() {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.getTotalLength();
        }
    }

    private void logCacheStatus() {
        if (!this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
            return;
        }
        int size = this.cache.size();
        int length = this.cache.getTotalLength();
        this.logger.atVerbose().addKeyValue(SIZE_KEY, (long)size).addKeyValue(TOTAL_LENGTH_KEY, (long)length).log("Cache entry added or updated. Total number of entries: {}; Total schema length: {}", new Object[]{size, length});
    }

    private static final class SchemaCache
    extends LinkedHashMap<String, Schema> {
        private static final long serialVersionUID = -1L;
        private final int capacity;
        private final HashMap<Schema, String> schemaToIdCache = new HashMap();
        private int totalLength;

        SchemaCache(int capacity) {
            super(64, 0.75f, true);
            this.capacity = capacity;
        }

        int getTotalLength() {
            return this.totalLength;
        }

        String getSchemaId(Schema schema) {
            String schemaId = this.schemaToIdCache.get(schema);
            if (schemaId != null) {
                super.get(schemaId);
            }
            return schemaId;
        }

        @Override
        public Schema put(String schemaId, Schema value) {
            Schema existing = super.put(schemaId, value);
            int currentLength = value.toString().length();
            if (existing == null) {
                this.totalLength += currentLength;
            } else {
                int difference = currentLength - existing.toString().length();
                this.totalLength -= difference;
            }
            this.schemaToIdCache.put(value, schemaId);
            return existing;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Schema> eldest) {
            boolean removingEntry;
            boolean bl = removingEntry = this.size() > this.capacity;
            if (removingEntry) {
                Schema value = eldest.getValue();
                this.totalLength -= value.toString().length();
                this.schemaToIdCache.remove(value);
            }
            return removingEntry;
        }
    }
}

