/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.ByteBufferInputStream;

class AvroSerializer {
    private static final Map<Class<?>, Schema> PRIMITIVE_SCHEMAS;
    private static final Schema NULL_SCHEMA;
    private static final int V1_HEADER_LENGTH = 10;
    private static final byte[] V1_HEADER;
    private final ClientLogger logger = new ClientLogger(AvroSerializer.class);
    private final boolean avroSpecificReader;
    private final EncoderFactory encoderFactory;
    private final DecoderFactory decoderFactory;

    AvroSerializer(boolean avroSpecificReader, EncoderFactory encoderFactory, DecoderFactory decoderFactory) {
        this.avroSpecificReader = avroSpecificReader;
        this.encoderFactory = Objects.requireNonNull(encoderFactory, "'encoderFactory' cannot be null.");
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "'decoderFactory' cannot be null.");
    }

    <T> byte[] serialize(T object, String schemaId) {
        byte[] byArray;
        Schema schema = AvroSerializer.getSchema(object);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (object instanceof byte[]) {
                outputStream.write((byte[])object);
            } else {
                BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)outputStream, null);
                Object writer = object instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(object, (Encoder)encoder);
                encoder.flush();
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new SchemaRegistryApacheAvroException("An error occurred while attempting to serialize to Avro.", e, schemaId)));
            }
        }
        outputStream.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T deserialize(ByteBuffer contents, Schema schemaObject, TypeReference<T> typeReference) {
        Objects.requireNonNull(contents, "'bytes' must not be null.");
        if (AvroSerializer.isSingleObjectEncoded(contents)) {
            BinaryMessageDecoder messageDecoder = new BinaryMessageDecoder((GenericData)SpecificData.get(), schemaObject);
            try {
                return (T)messageDecoder.decode(contents);
            }
            catch (IOException e) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new SchemaRegistryApacheAvroException("Unable to deserialize Avro schema object using binary message decoder.", e)));
            }
        }
        DatumReader<T> reader = this.getDatumReader(schemaObject, typeReference);
        try (ByteBufferInputStream input = new ByteBufferInputStream(Collections.singletonList(contents));){
            Object object = reader.read(null, (Decoder)this.decoderFactory.binaryDecoder((InputStream)input, null));
            return (T)object;
        }
        catch (IOException | RuntimeException e) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new SchemaRegistryApacheAvroException("Error deserializing raw Avro message.", e)));
        }
    }

    static Schema getSchema(Object object) {
        if (object instanceof GenericContainer) {
            return ((GenericContainer)object).getSchema();
        }
        if (object == null) {
            return NULL_SCHEMA;
        }
        Class<?> objectClass = object.getClass();
        Schema primitiveSchema = AvroSerializer.getPrimitiveSchema(objectClass);
        if (primitiveSchema != null) {
            return primitiveSchema;
        }
        throw new IllegalArgumentException("Unsupported Avro type. Supported types are null, GenericContainer, Boolean, Integer, Long, Float, Double, String, Byte[], Byte, ByteBuffer, and their primitive equivalents. Actual: " + objectClass);
    }

    static boolean isSingleObjectEncoded(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 10) {
            return false;
        }
        byteBuffer.mark();
        byte[] contents = new byte[10];
        byteBuffer.get(contents);
        byteBuffer.reset();
        return V1_HEADER[0] == contents[0] && V1_HEADER[1] == contents[1];
    }

    <T> Schema getSchemaFromTypeReference(Class<T> clazz) {
        Optional<Constructor> defaultConstructor;
        if (!GenericContainer.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            defaultConstructor = Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).findFirst();
        }
        catch (SecurityException e) {
            this.logger.info("Could not get declaring constructors for deserializing T ({}). Using writer schema.", new Object[]{clazz, e});
            return null;
        }
        if (!defaultConstructor.isPresent()) {
            return null;
        }
        Object instance = null;
        try {
            instance = defaultConstructor.get().newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.logger.info("Could not create new instance for deserializing T ({}). Using writer schema.", new Object[]{clazz, e});
        }
        return instance instanceof GenericContainer ? ((GenericContainer)instance).getSchema() : null;
    }

    private static Schema getPrimitiveSchema(Class<?> clazz) {
        Schema schema = PRIMITIVE_SCHEMAS.get(clazz);
        if (schema != null) {
            return schema;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return PRIMITIVE_SCHEMAS.get(String.class);
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return PRIMITIVE_SCHEMAS.get(Byte[].class);
        }
        return null;
    }

    private <T> DatumReader<T> getDatumReader(Schema writerSchema, TypeReference<T> typeReference) {
        Class clazz = typeReference.getJavaClass();
        Schema primitiveSchema = AvroSerializer.getPrimitiveSchema(clazz);
        if (primitiveSchema != null) {
            if (this.avroSpecificReader) {
                return new SpecificDatumReader(writerSchema);
            }
            return new GenericDatumReader(writerSchema);
        }
        Schema readerSchema = this.getSchemaFromTypeReference(clazz);
        if (readerSchema != null && !readerSchema.equals((Object)writerSchema)) {
            this.logger.verbose("The writer schema is different than reader schema. Using reader schema. Writer: '{}'. Reader: '{}'", new Object[]{writerSchema, readerSchema});
            return new SpecificDatumReader(writerSchema, readerSchema);
        }
        if (SpecificRecord.class.isAssignableFrom(clazz)) {
            return new SpecificDatumReader(writerSchema);
        }
        return new GenericDatumReader(writerSchema);
    }

    static {
        NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        V1_HEADER = new byte[]{-61, 1};
        HashMap<Class<Object>, Schema> schemas = new HashMap<Class<Object>, Schema>();
        Schema booleanSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        schemas.put(Boolean.class, booleanSchema);
        schemas.put(Boolean.TYPE, booleanSchema);
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        schemas.put(Integer.class, intSchema);
        schemas.put(Integer.TYPE, intSchema);
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        schemas.put(Long.class, longSchema);
        schemas.put(Long.TYPE, longSchema);
        Schema floatSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
        schemas.put(Float.class, floatSchema);
        schemas.put(Float.TYPE, floatSchema);
        Schema doubleSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        schemas.put(Double.class, doubleSchema);
        schemas.put(Double.TYPE, doubleSchema);
        Schema byteSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        schemas.put(Byte.TYPE, byteSchema);
        schemas.put(Byte.class, byteSchema);
        schemas.put(byte[].class, byteSchema);
        schemas.put(Byte[].class, byteSchema);
        schemas.put(ByteBuffer.class, byteSchema);
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        schemas.put(String.class, stringSchema);
        PRIMITIVE_SCHEMAS = Collections.unmodifiableMap(schemas);
    }
}

