/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ConfigurationSettingsFilter
implements JsonSerializable<ConfigurationSettingsFilter> {
    private final String key;
    private String label;
    private List<String> tags;

    public ConfigurationSettingsFilter(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public ConfigurationSettingsFilter setLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public ConfigurationSettingsFilter setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationSettingsFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationSettingsFilter)jsonReader.readObject(reader -> {
            boolean keyFound = false;
            String key = null;
            String label = null;
            List tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                    continue;
                }
                if ("label".equals(fieldName)) {
                    label = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound) {
                ConfigurationSettingsFilter deserializedConfigurationSettingsFilter = new ConfigurationSettingsFilter(key);
                deserializedConfigurationSettingsFilter.label = label;
                deserializedConfigurationSettingsFilter.tags = tags;
                return deserializedConfigurationSettingsFilter;
            }
            throw new IllegalStateException("Missing required property: key");
        });
    }
}

