/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.sdk.controller.group.global;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.UUIDs;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.sdk.config.GlobalThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.sdk.controller.group.global.GlobalThroughputControlClientItem;
import com.azure.cosmos.implementation.throughputControl.sdk.controller.group.global.GlobalThroughputControlConfigItem;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetrySpec;

public class ThroughputControlContainerManager {
    private static final Logger logger = LoggerFactory.getLogger(ThroughputControlContainerManager.class);
    private static final String CLIENT_ITEM_PARTITION_KEY_VALUE_SUFFIX = ".client";
    private static final String CONFIG_ITEM_ID_SUFFIX = ".info";
    private static final String CONFIG_ITEM_PARTITION_KEY_VALUE_SUFFIX = ".config";
    private static final String PARTITION_KEY_PATH = "/groupId";
    private final String clientItemId;
    private final String clientItemPartitionKeyValue;
    private final String configItemId;
    private final String configItemPartitionKeyValue;
    private final CosmosAsyncContainer globalControlContainer;
    private final GlobalThroughputControlGroup group;
    private GlobalThroughputControlConfigItem configItem;
    private GlobalThroughputControlClientItem clientItem;

    public ThroughputControlContainerManager(GlobalThroughputControlGroup group) {
        Preconditions.checkNotNull(group, "Global control group config can not be null");
        this.globalControlContainer = group.getGlobalControlContainer();
        this.group = group;
        String encodedGroupId = Utils.encodeUrlBase64String(this.group.getId().getBytes(StandardCharsets.UTF_8));
        this.clientItemId = encodedGroupId + UUIDs.nonBlockingRandomUUID();
        this.clientItemPartitionKeyValue = this.group.getIdPrefix() + CLIENT_ITEM_PARTITION_KEY_VALUE_SUFFIX;
        this.configItemId = encodedGroupId + CONFIG_ITEM_ID_SUFFIX;
        this.configItemPartitionKeyValue = this.group.getIdPrefix() + CONFIG_ITEM_PARTITION_KEY_VALUE_SUFFIX;
    }

    public Mono<GlobalThroughputControlClientItem> createGroupClientItem(double loadFactor, double allocatedThroughput) {
        CosmosItemRequestOptions requestOptions = new CosmosItemRequestOptions();
        requestOptions.setContentResponseOnWriteEnabled(true);
        return Mono.just((Object)new GlobalThroughputControlClientItem(this.clientItemId, this.clientItemPartitionKeyValue, loadFactor, allocatedThroughput, this.group.getControlItemExpireInterval())).flatMap(groupClientItem -> this.globalControlContainer.createItem(groupClientItem, requestOptions)).flatMap(itemResponse -> {
            this.clientItem = (GlobalThroughputControlClientItem)itemResponse.getItem();
            return Mono.just((Object)this.clientItem);
        });
    }

    public Mono<GlobalThroughputControlConfigItem> getOrCreateConfigItem() {
        CosmosItemRequestOptions requestOptions = new CosmosItemRequestOptions();
        requestOptions.setContentResponseOnWriteEnabled(true);
        GlobalThroughputControlConfigItem expectedConfigItem = new GlobalThroughputControlConfigItem(this.configItemId, this.configItemPartitionKeyValue, this.group.getTargetThroughput(), this.group.getTargetThroughputThreshold(), this.group.isDefault());
        return this.globalControlContainer.readItem(this.configItemId, new PartitionKey(this.configItemPartitionKeyValue), GlobalThroughputControlConfigItem.class).onErrorResume(throwable -> {
            CosmosException cosmosException = Utils.as(Exceptions.unwrap((Throwable)throwable), CosmosException.class);
            if (cosmosException != null && cosmosException.getStatusCode() == 404) {
                return this.globalControlContainer.createItem(expectedConfigItem, requestOptions);
            }
            return Mono.error((Throwable)throwable);
        }).retryWhen((Retry)RetrySpec.max((long)10L).filter(throwable -> {
            CosmosException cosmosException = Utils.as(Exceptions.unwrap((Throwable)throwable), CosmosException.class);
            return cosmosException != null && cosmosException.getStatusCode() == 409;
        })).flatMap(itemResponse -> {
            this.configItem = (GlobalThroughputControlConfigItem)itemResponse.getItem();
            if (!expectedConfigItem.equals(this.configItem)) {
                logger.warn("Group config using by this client is different than the one in control container, will be ignored. Using following config: {}", (Object)this.configItem.toString());
            }
            return Mono.just((Object)this.configItem);
        });
    }

    public Mono<Double> queryLoadFactorsOfAllClients(double clientLoadFactor) {
        String sqlQueryTest = "SELECT * FROM c WHERE c.groupId = @GROUPID AND c.id != @CLIENTITEMID";
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        parameters.add(new SqlParameter("@GROUPID", this.clientItemPartitionKeyValue));
        parameters.add(new SqlParameter("@CLIENTITEMID", this.clientItemId));
        SqlQuerySpec querySpec = new SqlQuerySpec(sqlQueryTest, parameters);
        return this.globalControlContainer.queryItems(querySpec, GlobalThroughputControlClientItem.class).collectList().flatMapMany(clientItemList -> Flux.fromIterable((Iterable)clientItemList)).map(clientItem -> clientItem.getLoadFactor()).reduce((Object)clientLoadFactor, (loadFactor1, loadFactor2) -> loadFactor1 + loadFactor2);
    }

    public Mono<GlobalThroughputControlClientItem> replaceOrCreateGroupClientItem(double loadFactor, double clientAllocatedThroughput) {
        CosmosItemRequestOptions itemRequestOptions = new CosmosItemRequestOptions();
        itemRequestOptions.setContentResponseOnWriteEnabled(true);
        return Mono.just((Object)this.clientItem).flatMap(groupClientItem -> {
            groupClientItem.setLoadFactor(loadFactor);
            groupClientItem.setAllocatedThroughput(clientAllocatedThroughput);
            return this.globalControlContainer.replaceItem(groupClientItem, groupClientItem.getId(), new PartitionKey(groupClientItem.getGroupId()), itemRequestOptions);
        }).onErrorResume(throwable -> {
            CosmosException cosmosException = Utils.as(Exceptions.unwrap((Throwable)throwable), CosmosException.class);
            if (cosmosException != null && cosmosException.getStatusCode() == 404) {
                logger.warn("Can not find the expected client item {}, will recreate a new one", (Object)this.clientItem.getId());
                return this.globalControlContainer.createItem(this.clientItem, itemRequestOptions).retryWhen((Retry)RetrySpec.max((long)5L));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(itemResponse -> {
            this.clientItem = (GlobalThroughputControlClientItem)itemResponse.getItem();
            return Mono.just((Object)this.clientItem);
        });
    }

    public Mono<ThroughputControlContainerManager> validateControlContainer() {
        return this.globalControlContainer.read().map(containerResponse -> containerResponse.getProperties()).flatMap(containerProperties -> {
            boolean isPartitioned;
            boolean bl = isPartitioned = containerProperties.getPartitionKeyDefinition() != null && containerProperties.getPartitionKeyDefinition().getPaths() != null && containerProperties.getPartitionKeyDefinition().getPaths().size() > 0;
            if (!isPartitioned || containerProperties.getPartitionKeyDefinition().getPaths().size() != 1 || !containerProperties.getPartitionKeyDefinition().getPaths().get(0).equals(PARTITION_KEY_PATH)) {
                return Mono.error((Throwable)new IllegalArgumentException("The control container must have partition key equal to /groupId"));
            }
            return Mono.empty();
        }).thenReturn((Object)this);
    }
}

