/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ObservableHelper;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker;
import com.azure.cosmos.implementation.query.Fetcher;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.FeedResponse;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

class ServerSideOnlyContinuationNonDocumentFetcherImpl<T>
extends Fetcher<T> {
    private final BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc;
    private final Supplier<DocumentClientRetryPolicy> retryPolicySupplier;
    private volatile String continuationToken;

    public ServerSideOnlyContinuationNonDocumentFetcherImpl(RxDocumentClientImpl client, BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, String continuationToken, boolean isChangeFeed, int top, int maxItemCount, OperationContextAndListenerTuple operationContext, List<CosmosDiagnostics> cancelledRequestDiagnosticsTracker, GlobalEndpointManager globalEndpointManager, GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker globalPartitionEndpointManagerForPerPartitionCircuitBreaker) {
        super(executeFunc, isChangeFeed, top, maxItemCount, operationContext, cancelledRequestDiagnosticsTracker, globalEndpointManager, globalPartitionEndpointManagerForPerPartitionCircuitBreaker);
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        Preconditions.checkNotNull(createRequestFunc, "Argument 'createRequestFunc' must not be null.");
        this.createRequestFunc = createRequestFunc;
        this.continuationToken = continuationToken;
        this.retryPolicySupplier = () -> client.getResetSessionTokenRetryPolicy().getRequestPolicy(null);
    }

    @Override
    protected String applyServerResponseContinuation(String serverContinuationToken, RxDocumentServiceRequest request, FeedResponse<T> response) {
        this.continuationToken = serverContinuationToken;
        return this.continuationToken;
    }

    @Override
    public Mono<FeedResponse<T>> nextPage() {
        DocumentClientRetryPolicy retryPolicy = this.retryPolicySupplier.get();
        if (retryPolicy == null) {
            return this.nextPageCore(null);
        }
        return ObservableHelper.inlineIfPossible(() -> this.nextPageCore(retryPolicy), retryPolicy);
    }

    @Override
    protected RxDocumentServiceRequest createRequest(int maxItemCount, DocumentClientRetryPolicy documentClientRetryPolicy) {
        RxDocumentServiceRequest request = this.createRequestFunc.apply(this.continuationToken, maxItemCount);
        if (documentClientRetryPolicy != null) {
            documentClientRetryPolicy.onBeforeSendRequest(request);
        }
        return request;
    }

    @Override
    protected boolean isFullyDrained(boolean isChangeFeed, FeedResponse<T> response) {
        return StringUtils.isEmpty(this.continuationToken) || isChangeFeed && BridgeInternal.noChanges(response);
    }

    @Override
    protected String getContinuationForLogging() {
        return this.continuationToken;
    }
}

