/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.guava27;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Strings {
    private static final Logger logger = LoggerFactory.getLogger(Strings.class);

    public static String lenientFormat(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Strings.lenientToString(args[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(Object o) {
        try {
            return String.valueOf(o);
        }
        catch (Exception e) {
            String objectToString = o.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o));
            logger.warn("Exception during lenientFormat for " + objectToString, (Throwable)e);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }
}

