/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.StorePayload;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeStorePayload
implements StorePayload<JsonNode> {
    private static final Logger logger = LoggerFactory.getLogger(JsonNodeStorePayload.class);
    private static final CharsetDecoder fallbackCharsetDecoder = JsonNodeStorePayload.getFallbackCharsetDecoder();
    private final int responsePayloadSize;
    private final JsonNode jsonValue;

    public JsonNodeStorePayload(ByteBufInputStream bufferStream, int readableBytes, Map<String, String> responseHeaders) {
        if (readableBytes > 0) {
            this.responsePayloadSize = readableBytes;
            this.jsonValue = JsonNodeStorePayload.fromJson(bufferStream, readableBytes, responseHeaders);
        } else {
            this.responsePayloadSize = 0;
            this.jsonValue = null;
        }
    }

    private static JsonNode fromJson(ByteBufInputStream bufferStream, int readableBytes, Map<String, String> responseHeaders) {
        byte[] bytes = new byte[readableBytes];
        try {
            bufferStream.read(bytes);
            return Utils.getSimpleObjectMapper().readTree(bytes);
        }
        catch (IOException e) {
            if (fallbackCharsetDecoder != null) {
                logger.warn("Unable to parse JSON, fallback to use customized charset decoder.", (Throwable)e);
                return JsonNodeStorePayload.fromJsonWithFallbackCharsetDecoder(bytes, responseHeaders);
            }
            String baseErrorMessage = "Failed to parse JSON document. No fallback charset decoder configured.";
            if (Configs.isNonParseableDocumentLoggingEnabled()) {
                String documentSample = Base64.getEncoder().encodeToString(bytes);
                logger.error(baseErrorMessage + " Document in Base64 format: [" + documentSample + "]", (Throwable)e);
            } else {
                logger.error(baseErrorMessage);
            }
            IllegalStateException innerException = new IllegalStateException("Unable to parse JSON.", e);
            throw Utils.createCosmosException(400, 21011, innerException, responseHeaders);
        }
    }

    private static JsonNode fromJsonWithFallbackCharsetDecoder(byte[] bytes, Map<String, String> responseHeaders) {
        try {
            String sanitizedJson = fallbackCharsetDecoder.decode(ByteBuffer.wrap(bytes)).toString();
            return Utils.getSimpleObjectMapper().readTree(sanitizedJson);
        }
        catch (IOException e) {
            String baseErrorMessage = "Failed to parse JSON document even after applying fallback charset decoder.";
            if (Configs.isNonParseableDocumentLoggingEnabled()) {
                String documentSample = Base64.getEncoder().encodeToString(bytes);
                logger.error(baseErrorMessage + " Document in Base64 format: [" + documentSample + "]", (Throwable)e);
            } else {
                logger.error(baseErrorMessage);
            }
            IllegalStateException nestedException = new IllegalStateException(String.format("Unable to parse JSON with fallback charset decoder[OnMalformedInput %s, OnUnmappedCharacter %s]", Configs.getCharsetDecoderErrorActionOnMalformedInput(), Configs.getCharsetDecoderErrorActionOnUnmappedCharacter()), e);
            throw Utils.createCosmosException(400, 21011, nestedException, responseHeaders);
        }
    }

    @Override
    public int getResponsePayloadSize() {
        return this.responsePayloadSize;
    }

    @Override
    public JsonNode getPayload() {
        return this.jsonValue;
    }

    private static CharsetDecoder getFallbackCharsetDecoder() {
        if (StringUtil.isNullOrEmpty((String)Configs.getCharsetDecoderErrorActionOnMalformedInput()) && StringUtil.isNullOrEmpty((String)Configs.getCharsetDecoderErrorActionOnUnmappedCharacter())) {
            logger.debug("No fallback charset decoder is enabled");
            return null;
        }
        CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder();
        switch (Configs.getCharsetDecoderErrorActionOnMalformedInput().toUpperCase()) {
            case "REPLACE": {
                charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
                break;
            }
            case "IGNORE": {
                charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
                break;
            }
            default: {
                logger.warn("Will use default error action for malformed input config {}", (Object)Configs.getCharsetDecoderErrorActionOnMalformedInput());
            }
        }
        switch (Configs.getCharsetDecoderErrorActionOnUnmappedCharacter().toUpperCase()) {
            case "REPLACE": {
                charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                break;
            }
            case "IGNORE": {
                charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                break;
            }
            default: {
                logger.warn("Will use default error action for unmapped character config {}", (Object)Configs.getCharsetDecoderErrorActionOnUnmappedCharacter());
            }
        }
        return charsetDecoder;
    }
}

