/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import java.util.ArrayList;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AttributeNamingScheme {
    PRE_V1_RELEASE,
    V1;

    private static final Logger logger;

    public static EnumSet<AttributeNamingScheme> parse(String name) {
        if (name == null || name.isEmpty() || "All".equalsIgnoreCase(name) || "Default".equalsIgnoreCase(name)) {
            return EnumSet.allOf(AttributeNamingScheme.class);
        }
        String[] textValues = name.split(",");
        ArrayList<AttributeNamingScheme> schemeList = new ArrayList<AttributeNamingScheme>();
        for (String textValue : textValues) {
            boolean foundTextValue = false;
            for (AttributeNamingScheme scheme : AttributeNamingScheme.values()) {
                if (!scheme.name().equalsIgnoreCase(textValue)) continue;
                foundTextValue = true;
                schemeList.add(scheme);
                break;
            }
            if (foundTextValue) continue;
            logger.error("Invalid AttributeNamingScheme: " + textValue + " in '" + name + "' - proceeding with default value 'ALL'");
            return EnumSet.allOf(AttributeNamingScheme.class);
        }
        if (schemeList.size() > 0) {
            return EnumSet.copyOf(schemeList);
        }
        return EnumSet.allOf(AttributeNamingScheme.class);
    }

    static {
        logger = LoggerFactory.getLogger(AttributeNamingScheme.class);
    }
}

