/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion;

import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.LeaseManager;
import com.azure.cosmos.implementation.changefeed.PartitionSupervisor;
import com.azure.cosmos.implementation.changefeed.PartitionSupervisorFactory;
import com.azure.cosmos.implementation.changefeed.epkversion.LeaseRenewerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessor;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessorFactory;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionSupervisorImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import reactor.core.scheduler.Scheduler;

class PartitionSupervisorFactoryImpl<T>
implements PartitionSupervisorFactory {
    private final ChangeFeedObserverFactory<T> observerFactory;
    private final LeaseManager leaseManager;
    private final ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private final PartitionProcessorFactory<T> partitionProcessorFactory;
    private final Scheduler scheduler;
    private final Class<T> partitionProcessItemType;

    public PartitionSupervisorFactoryImpl(ChangeFeedObserverFactory<T> observerFactory, LeaseManager leaseManager, PartitionProcessorFactory<T> partitionProcessorFactory, ChangeFeedProcessorOptions options, Scheduler scheduler, Class<T> partitionProcessItemType) {
        Preconditions.checkNotNull(observerFactory, "Argument 'observerFactory' can not be null");
        Preconditions.checkNotNull(leaseManager, "Argument 'leaseManager' can not be null");
        Preconditions.checkNotNull(options, "Argument 'options' can not be null");
        Preconditions.checkNotNull(partitionProcessorFactory, "Argument 'partitionProcessorFactory' can not be null");
        Preconditions.checkNotNull(partitionProcessItemType, "Argument 'partitionProcessItemType' can not be null");
        this.observerFactory = observerFactory;
        this.leaseManager = leaseManager;
        this.changeFeedProcessorOptions = options;
        this.partitionProcessorFactory = partitionProcessorFactory;
        this.scheduler = scheduler;
        this.partitionProcessItemType = partitionProcessItemType;
    }

    @Override
    public PartitionSupervisor create(Lease lease) {
        Preconditions.checkNotNull(lease, "Argument 'lease' can not be null");
        ChangeFeedObserver<T> changeFeedObserver = this.observerFactory.createObserver();
        PartitionProcessor processor = this.partitionProcessorFactory.create(lease, changeFeedObserver, this.partitionProcessItemType);
        LeaseRenewerImpl renewer = new LeaseRenewerImpl(lease, this.leaseManager, this.changeFeedProcessorOptions.getLeaseRenewInterval());
        return new PartitionSupervisorImpl<T>(lease, changeFeedObserver, processor, renewer, this.scheduler);
    }
}

