/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.ResourceThrottleRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import reactor.core.publisher.Mono;

public final class MetadataThrottlingRetryPolicy
extends ResourceThrottleRetryPolicy {
    private static final int RANDOM_SALT_IN_MS = 100;
    private static final int MAX_ATTEMPT_COUNT = Integer.MAX_VALUE;
    private static final Duration MAX_RETRY_WAIT_TIME = Duration.ofSeconds(2147482L);

    public MetadataThrottlingRetryPolicy(RetryContext retryContext) {
        super(Integer.MAX_VALUE, MAX_RETRY_WAIT_TIME, retryContext, false);
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        return super.shouldRetry(exception).flatMap(shouldRetryResult -> {
            if (shouldRetryResult.shouldRetry) {
                shouldRetryResult.withRandomSalt(ThreadLocalRandom.current().nextInt(101));
            }
            return Mono.just((Object)shouldRetryResult);
        });
    }
}

