/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import java.util.Map;

public class LeaseNotFoundException
extends CosmosException {
    public LeaseNotFoundException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super("Lease not found", 410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
        this.setSubStatus(1022);
    }

    public LeaseNotFoundException(String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super("Lease not found", 410, null, responseHeaders);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
        this.setSubStatus(1022);
    }

    private void setSubStatus(int subStatusCode) {
        this.getResponseHeaders().put("x-ms-substatus", Integer.toString(subStatusCode));
    }
}

