/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.IRetryPolicyFactory;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public interface IDocumentQueryClient {
    public RxCollectionCache getCollectionCache();

    public IPartitionKeyRangeCache getPartitionKeyRangeCache();

    public IRetryPolicyFactory getResetSessionTokenRetryPolicy();

    public ConsistencyLevel getDefaultConsistencyLevelAsync();

    public ConsistencyLevel getDesiredConsistencyLevelAsync();

    public Mono<RxDocumentServiceResponse> executeQueryAsync(RxDocumentServiceRequest var1);

    public QueryCompatibilityMode getQueryCompatibilityMode();

    public <T> Mono<T> executeFeedOperationWithAvailabilityStrategy(ResourceType var1, OperationType var2, Supplier<DocumentClientRetryPolicy> var3, RxDocumentServiceRequest var4, BiFunction<Supplier<DocumentClientRetryPolicy>, RxDocumentServiceRequest, Mono<T>> var5, String var6);

    public <T> CosmosItemSerializer getEffectiveItemSerializer(CosmosQueryRequestOptions var1);

    public ReadConsistencyStrategy getReadConsistencyStrategy();

    public ConsistencyLevel getConsistencyLevel();

    public void validateAndLogNonDefaultReadConsistencyStrategy(String var1);

    public Mono<RxDocumentServiceResponse> readFeedAsync(RxDocumentServiceRequest var1);

    public Mono<RxDocumentServiceRequest> populateFeedRangeHeader(RxDocumentServiceRequest var1);

    public Mono<RxDocumentServiceRequest> addPartitionLevelUnavailableRegionsOnRequest(RxDocumentServiceRequest var1, CosmosQueryRequestOptions var2, DocumentClientRetryPolicy var3);

    public GlobalEndpointManager getGlobalEndpointManager();

    public GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker getGlobalPartitionEndpointManagerForCircuitBreaker();

    public static enum QueryCompatibilityMode {
        Default,
        Query,
        SqlQuery;

    }
}

