/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.perPartitionCircuitBreaker;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeWrapper;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.directconnectivity.GatewayAddressCache;
import com.azure.cosmos.implementation.directconnectivity.GlobalAddressResolver;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.ConsecutiveExceptionBasedCircuitBreaker;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.LocationHealthStatus;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.LocationSpecificHealthContext;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.LocationSpecificHealthContextTransitionHandler;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.PartitionLevelCircuitBreakerConfig;
import com.azure.cosmos.implementation.routing.RegionalRoutingContext;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.class);
    private final GlobalEndpointManager globalEndpointManager;
    private final ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionLevelLocationUnavailabilityInfo> partitionKeyRangeToLocationSpecificUnavailabilityInfo;
    private LocationSpecificHealthContextTransitionHandler locationSpecificHealthContextTransitionHandler;
    private ConsecutiveExceptionBasedCircuitBreaker consecutiveExceptionBasedCircuitBreaker;
    private final AtomicReference<GlobalAddressResolver> globalAddressResolverSnapshot;
    private final ConcurrentHashMap<RegionalRoutingContext, String> regionalRoutingContextToRegion;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Scheduler partitionRecoveryScheduler = Schedulers.newSingle((String)"partition-availability-staleness-check", (boolean)true);

    public GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker(GlobalEndpointManager globalEndpointManager) {
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo = new ConcurrentHashMap();
        this.globalEndpointManager = globalEndpointManager;
        PartitionLevelCircuitBreakerConfig partitionLevelCircuitBreakerConfig = Configs.getPartitionLevelCircuitBreakerConfig();
        this.consecutiveExceptionBasedCircuitBreaker = new ConsecutiveExceptionBasedCircuitBreaker(partitionLevelCircuitBreakerConfig);
        this.locationSpecificHealthContextTransitionHandler = new LocationSpecificHealthContextTransitionHandler(this.consecutiveExceptionBasedCircuitBreaker);
        this.globalAddressResolverSnapshot = new AtomicReference();
        this.regionalRoutingContextToRegion = new ConcurrentHashMap();
    }

    public void init() {
        if (this.consecutiveExceptionBasedCircuitBreaker.isPartitionLevelCircuitBreakerEnabled()) {
            this.updateStaleLocationInfo().subscribeOn(this.partitionRecoveryScheduler).subscribe();
        }
    }

    public void handleLocationExceptionForPartitionKeyRange(RxDocumentServiceRequest request, RegionalRoutingContext failedRegionalRoutingContext) {
        Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
        PartitionKeyRange resolvedPartitionKeyRangeForCircuitBreaker = request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker;
        PartitionKeyRange resolvedPartitionKeyRange = request.requestContext.resolvedPartitionKeyRange;
        if (resolvedPartitionKeyRangeForCircuitBreaker != null && resolvedPartitionKeyRange == null) {
            return;
        }
        Preconditions.checkNotNull(request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker, "Argument 'request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker' cannot be null!");
        String collectionResourceId = request.getResourceId();
        Preconditions.checkNotNull(collectionResourceId, "Argument 'collectionResourceId' cannot be null!");
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(resolvedPartitionKeyRangeForCircuitBreaker, collectionResourceId);
        AtomicBoolean isFailoverPossible = new AtomicBoolean(true);
        AtomicBoolean isFailureThresholdBreached = new AtomicBoolean(false);
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.compute(partitionKeyRangeWrapper, (partitionKeyRangeWrapperAsKey, partitionLevelLocationUnavailabilityInfoAsVal) -> {
            if (partitionLevelLocationUnavailabilityInfoAsVal == null) {
                partitionLevelLocationUnavailabilityInfoAsVal = new PartitionLevelLocationUnavailabilityInfo();
            }
            isFailureThresholdBreached.set(((PartitionLevelLocationUnavailabilityInfo)partitionLevelLocationUnavailabilityInfoAsVal).handleException(partitionKeyRangeWrapperAsKey, failedRegionalRoutingContext, request.isReadOnlyRequest()));
            if (isFailureThresholdBreached.get()) {
                UnmodifiableList<RegionalRoutingContext> applicableRegionalRoutingContexts = request.isReadOnlyRequest() ? this.globalEndpointManager.getApplicableReadRegionalRoutingContexts(request.requestContext.getExcludeRegions()) : this.globalEndpointManager.getApplicableWriteRegionalRoutingContexts(request.requestContext.getExcludeRegions());
                isFailoverPossible.set(partitionLevelLocationUnavailabilityInfoAsVal.areLocationsAvailableForPartitionKeyRange(applicableRegionalRoutingContexts));
            }
            request.requestContext.setPerPartitionCircuitBreakerInfoHolder(((PartitionLevelLocationUnavailabilityInfo)partitionLevelLocationUnavailabilityInfoAsVal).regionToLocationSpecificHealthContext);
            return partitionLevelLocationUnavailabilityInfoAsVal;
        });
        if (isFailoverPossible.get()) {
            return;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("It is not possible to mark region {} as Unavailable for partition key range {}-{} and collection rid {} as all regions will be Unavailable in that case, will remove health status tracking for this partition!", new Object[]{this.globalEndpointManager.getRegionName(failedRegionalRoutingContext.getGatewayRegionalEndpoint(), request.isReadOnlyRequest() ? OperationType.Read : OperationType.Create), resolvedPartitionKeyRangeForCircuitBreaker.getMinInclusive(), resolvedPartitionKeyRangeForCircuitBreaker.getMaxExclusive(), collectionResourceId});
        }
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.remove(partitionKeyRangeWrapper);
    }

    public void handleLocationSuccessForPartitionKeyRange(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
        PartitionKeyRange resolvedPartitionKeyRangeForCircuitBreaker = request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker;
        PartitionKeyRange resolvedPartitionKeyRange = request.requestContext.resolvedPartitionKeyRange;
        if (resolvedPartitionKeyRangeForCircuitBreaker != null && resolvedPartitionKeyRange == null) {
            return;
        }
        Preconditions.checkNotNull(request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker, "Argument 'request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker' cannot be null!");
        String resourceId = request.getResourceId();
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(resolvedPartitionKeyRangeForCircuitBreaker, resourceId);
        RegionalRoutingContext succeededRegionalRoutingContext = request.requestContext.regionalRoutingContextToRoute;
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.compute(partitionKeyRangeWrapper, (partitionKeyRangeWrapperAsKey, partitionKeyRangeToFailoverInfoAsVal) -> {
            if (partitionKeyRangeToFailoverInfoAsVal == null) {
                partitionKeyRangeToFailoverInfoAsVal = new PartitionLevelLocationUnavailabilityInfo();
            }
            ((PartitionLevelLocationUnavailabilityInfo)partitionKeyRangeToFailoverInfoAsVal).handleSuccess(partitionKeyRangeWrapper, succeededRegionalRoutingContext, request.isReadOnlyRequest());
            request.requestContext.setPerPartitionCircuitBreakerInfoHolder(((PartitionLevelLocationUnavailabilityInfo)partitionKeyRangeToFailoverInfoAsVal).regionToLocationSpecificHealthContext);
            return partitionKeyRangeToFailoverInfoAsVal;
        });
    }

    public List<String> getUnavailableRegionsForPartitionKeyRange(RxDocumentServiceRequest request, String collectionResourceId, PartitionKeyRange partitionKeyRange) {
        if (!this.isPerPartitionLevelCircuitBreakingApplicable(request)) {
            return Collections.emptyList();
        }
        Preconditions.checkNotNull(partitionKeyRange, "Argument 'partitionKeyRange' cannot be null!");
        Preconditions.checkNotNull(collectionResourceId, "Argument 'collectionResourceId' cannot be null!");
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(partitionKeyRange, collectionResourceId);
        PartitionLevelLocationUnavailabilityInfo partitionLevelLocationUnavailabilityInfoSnapshot = this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.get(partitionKeyRangeWrapper);
        ArrayList<String> unavailableRegions = new ArrayList<String>();
        if (partitionLevelLocationUnavailabilityInfoSnapshot != null) {
            ConcurrentHashMap locationEndpointToFailureMetricsForPartition = partitionLevelLocationUnavailabilityInfoSnapshot.locationEndpointToLocationSpecificContextForPartition;
            PriorityQueue<RegionalRoutingContext> unavailableRoutingContexts = new PriorityQueue<RegionalRoutingContext>((endpoint1, endpoint2) -> {
                LocationSpecificHealthContext locationSpecificHealthContextForEndpoint1 = (LocationSpecificHealthContext)locationEndpointToFailureMetricsForPartition.get(endpoint1);
                LocationSpecificHealthContext locationSpecificHealthContextForEndpoint2 = (LocationSpecificHealthContext)locationEndpointToFailureMetricsForPartition.get(endpoint2);
                if (locationSpecificHealthContextForEndpoint1 == null || locationSpecificHealthContextForEndpoint2 == null) {
                    return 0;
                }
                return locationSpecificHealthContextForEndpoint1.getUnavailableSince().compareTo(locationSpecificHealthContextForEndpoint2.getUnavailableSince());
            });
            for (Map.Entry pair : locationEndpointToFailureMetricsForPartition.entrySet()) {
                RegionalRoutingContext regionalRoutingContext = (RegionalRoutingContext)pair.getKey();
                LocationSpecificHealthContext locationSpecificHealthContext = (LocationSpecificHealthContext)pair.getValue();
                if (locationSpecificHealthContext.getLocationHealthStatus() != LocationHealthStatus.Unavailable) continue;
                unavailableRoutingContexts.add(regionalRoutingContext);
            }
            while (!unavailableRoutingContexts.isEmpty()) {
                RegionalRoutingContext unavailableRegionalRoutingContext = (RegionalRoutingContext)unavailableRoutingContexts.poll();
                URI unavailableEndpoint = unavailableRegionalRoutingContext.getGatewayRegionalEndpoint();
                unavailableRegions.add(this.globalEndpointManager.getRegionName(unavailableEndpoint, request.isReadOnlyRequest() ? OperationType.Read : OperationType.Create));
            }
        }
        return UnmodifiableList.unmodifiableList(unavailableRegions);
    }

    private Flux<?> updateStaleLocationInfo() {
        return Mono.just((Object)1).delayElement(Duration.ofSeconds(Configs.getStalePartitionUnavailabilityRefreshIntervalInSeconds())).repeat(() -> !this.isClosed.get()).flatMap(ignore -> Flux.fromIterable(this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.entrySet()), 1, 1).flatMap(partitionKeyRangeWrapperToPartitionKeyRangeWrapperPair -> {
            logger.debug("Background updateStaleLocationInfo kicking in...");
            try {
                PartitionKeyRangeWrapper partitionKeyRangeWrapper = (PartitionKeyRangeWrapper)partitionKeyRangeWrapperToPartitionKeyRangeWrapperPair.getKey();
                PartitionLevelLocationUnavailabilityInfo partitionLevelLocationUnavailabilityInfo = this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.get(partitionKeyRangeWrapper);
                if (partitionLevelLocationUnavailabilityInfo != null) {
                    ArrayList<Pair<PartitionKeyRangeWrapper, Pair<RegionalRoutingContext, LocationSpecificHealthContext>>> locationToLocationSpecificHealthContextList = new ArrayList<Pair<PartitionKeyRangeWrapper, Pair<RegionalRoutingContext, LocationSpecificHealthContext>>>();
                    for (Map.Entry locationToLocationLevelMetrics : partitionLevelLocationUnavailabilityInfo.locationEndpointToLocationSpecificContextForPartition.entrySet()) {
                        RegionalRoutingContext locationWithStaleUnavailabilityInfo = (RegionalRoutingContext)locationToLocationLevelMetrics.getKey();
                        LocationSpecificHealthContext locationSpecificHealthContext = (LocationSpecificHealthContext)locationToLocationLevelMetrics.getValue();
                        if (locationSpecificHealthContext.isRegionAvailableToProcessRequests()) continue;
                        locationToLocationSpecificHealthContextList.add(Pair.of(partitionKeyRangeWrapper, Pair.of(locationWithStaleUnavailabilityInfo, locationSpecificHealthContext)));
                    }
                    if (locationToLocationSpecificHealthContextList.isEmpty()) {
                        return Flux.empty();
                    }
                    return Flux.fromIterable(locationToLocationSpecificHealthContextList);
                }
                return Mono.empty();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception : {} was thrown trying to recover an Unavailable partition key range!", (Object)e.getMessage());
                }
                return Flux.empty();
            }
        }, 1, 1).flatMap(locationToLocationSpecificHealthContextPair -> {
            try {
                PartitionKeyRangeWrapper partitionKeyRangeWrapper = (PartitionKeyRangeWrapper)locationToLocationSpecificHealthContextPair.getLeft();
                RegionalRoutingContext locationWithStaleUnavailabilityInfo = (RegionalRoutingContext)((Pair)locationToLocationSpecificHealthContextPair.getRight()).getLeft();
                PartitionLevelLocationUnavailabilityInfo partitionLevelLocationUnavailabilityInfo = this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.get(partitionKeyRangeWrapper);
                if (partitionLevelLocationUnavailabilityInfo != null) {
                    GlobalAddressResolver globalAddressResolver = this.globalAddressResolverSnapshot.get();
                    if (globalAddressResolver != null) {
                        GatewayAddressCache gatewayAddressCache = globalAddressResolver.getGatewayAddressCache(locationWithStaleUnavailabilityInfo.getGatewayRegionalEndpoint());
                        if (gatewayAddressCache != null) {
                            return gatewayAddressCache.submitOpenConnectionTasks(partitionKeyRangeWrapper.getPartitionKeyRange(), partitionKeyRangeWrapper.getCollectionResourceId()).timeout(Duration.ofSeconds(Configs.getConnectionEstablishmentTimeoutForPartitionRecoveryInSeconds())).doOnComplete(() -> {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Partition health recovery query for partition key range : {} and collection rid : {} has succeeded...", (Object)partitionKeyRangeWrapper.getPartitionKeyRange(), (Object)partitionKeyRangeWrapper.getCollectionResourceId());
                                }
                                partitionLevelLocationUnavailabilityInfo.locationEndpointToLocationSpecificContextForPartition.compute(locationWithStaleUnavailabilityInfo, (locationWithStaleUnavailabilityInfoAsKey, locationSpecificContextAsVal) -> {
                                    if (locationSpecificContextAsVal != null) {
                                        locationSpecificContextAsVal = this.locationSpecificHealthContextTransitionHandler.handleSuccess((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, this.regionalRoutingContextToRegion.getOrDefault(locationWithStaleUnavailabilityInfoAsKey, ""), false, true);
                                    }
                                    return locationSpecificContextAsVal;
                                });
                            }).onErrorResume(throwable -> {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("An exception : {} was thrown trying to recover an Unavailable partition key range!", (Object)throwable.getMessage());
                                }
                                return Mono.empty();
                            });
                        }
                    } else {
                        partitionLevelLocationUnavailabilityInfo.locationEndpointToLocationSpecificContextForPartition.compute(locationWithStaleUnavailabilityInfo, (locationWithStaleUnavailabilityInfoAsKey, locationSpecificContextAsVal) -> {
                            if (locationSpecificContextAsVal != null) {
                                locationSpecificContextAsVal = this.locationSpecificHealthContextTransitionHandler.handleSuccess((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, this.regionalRoutingContextToRegion.getOrDefault(locationWithStaleUnavailabilityInfoAsKey, ""), false, true);
                            }
                            return locationSpecificContextAsVal;
                        });
                    }
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception {} was thrown trying to recover an Unavailable partition key range!", (Object)e.getMessage());
                }
                return Flux.empty();
            }
            return Flux.empty();
        }, 1, 1).onErrorResume(throwable -> {
            if (logger.isWarnEnabled()) {
                logger.warn("An exception : {} was thrown trying to recover an Unavailable partition key range!, fail-back flow won't be executed!", (Object)throwable.getMessage());
            }
            return Flux.empty();
        });
    }

    public boolean isPerPartitionLevelCircuitBreakingApplicable(RxDocumentServiceRequest request) {
        if (!this.consecutiveExceptionBasedCircuitBreaker.isPartitionLevelCircuitBreakerEnabled()) {
            return false;
        }
        if (request == null) {
            return false;
        }
        if (request.getResourceType() != ResourceType.Document) {
            return false;
        }
        if (request.getOperationType() == OperationType.QueryPlan) {
            return false;
        }
        if (request.requestContext == null) {
            return false;
        }
        GlobalEndpointManager globalEndpointManager = this.globalEndpointManager;
        if (!globalEndpointManager.canUseMultipleWriteLocations(request)) {
            if (!request.isReadOnlyRequest()) {
                return false;
            }
            UnmodifiableList<RegionalRoutingContext> applicableReadEndpoints = globalEndpointManager.getApplicableReadRegionalRoutingContexts(Collections.emptyList());
            return applicableReadEndpoints != null && applicableReadEndpoints.size() > 1;
        }
        UnmodifiableList<RegionalRoutingContext> applicableWriteEndpoints = globalEndpointManager.getApplicableWriteRegionalRoutingContexts(Collections.emptyList());
        return applicableWriteEndpoints != null && applicableWriteEndpoints.size() > 1;
    }

    public void setGlobalAddressResolver(GlobalAddressResolver globalAddressResolver) {
        this.globalAddressResolverSnapshot.set(globalAddressResolver);
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.partitionRecoveryScheduler.dispose();
    }

    public ConsecutiveExceptionBasedCircuitBreaker getConsecutiveExceptionBasedCircuitBreaker() {
        return this.consecutiveExceptionBasedCircuitBreaker;
    }

    public PartitionLevelCircuitBreakerConfig getCircuitBreakerConfig() {
        return this.consecutiveExceptionBasedCircuitBreaker.getPartitionLevelCircuitBreakerConfig();
    }

    public synchronized void resetCircuitBreakerConfig() {
        PartitionLevelCircuitBreakerConfig partitionLevelCircuitBreakerConfig = Configs.getPartitionLevelCircuitBreakerConfig();
        this.consecutiveExceptionBasedCircuitBreaker = new ConsecutiveExceptionBasedCircuitBreaker(partitionLevelCircuitBreakerConfig);
        this.locationSpecificHealthContextTransitionHandler = new LocationSpecificHealthContextTransitionHandler(this.consecutiveExceptionBasedCircuitBreaker);
    }

    private class PartitionLevelLocationUnavailabilityInfo {
        private final ConcurrentHashMap<RegionalRoutingContext, LocationSpecificHealthContext> locationEndpointToLocationSpecificContextForPartition = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, LocationSpecificHealthContext> regionToLocationSpecificHealthContext = new ConcurrentHashMap();
        private final LocationSpecificHealthContextTransitionHandler locationSpecificHealthContextTransitionHandler;

        private PartitionLevelLocationUnavailabilityInfo() {
            this.locationSpecificHealthContextTransitionHandler = GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.locationSpecificHealthContextTransitionHandler;
        }

        private boolean handleException(PartitionKeyRangeWrapper partitionKeyRangeWrapper, RegionalRoutingContext regionalRoutingContextWithAnException, boolean isReadOnlyRequest) {
            AtomicBoolean isExceptionThresholdBreached = new AtomicBoolean(false);
            this.locationEndpointToLocationSpecificContextForPartition.compute(regionalRoutingContextWithAnException, (regionalRoutingContextAsKey, locationSpecificContextAsVal) -> {
                if (locationSpecificContextAsVal == null) {
                    locationSpecificContextAsVal = new LocationSpecificHealthContext.Builder().withSuccessCountForWriteForRecovery(0).withExceptionCountForWriteForCircuitBreaking(0).withSuccessCountForReadForRecovery(0).withExceptionCountForReadForCircuitBreaking(0).withUnavailableSince(Instant.MAX).withLocationHealthStatus(LocationHealthStatus.HealthyWithFailures).withExceptionThresholdBreached(false).build();
                }
                LocationSpecificHealthContext locationSpecificHealthContextAfterTransition = this.locationSpecificHealthContextTransitionHandler.handleException((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.getOrDefault(regionalRoutingContextWithAnException, ""), isReadOnlyRequest);
                if (GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.get(regionalRoutingContextAsKey) == null) {
                    GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.put(regionalRoutingContextAsKey, GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.globalEndpointManager.getRegionName(regionalRoutingContextAsKey.getGatewayRegionalEndpoint(), isReadOnlyRequest ? OperationType.Read : OperationType.Create));
                }
                String region = (String)GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.get(regionalRoutingContextAsKey);
                this.regionToLocationSpecificHealthContext.put(region, locationSpecificHealthContextAfterTransition);
                isExceptionThresholdBreached.set(locationSpecificHealthContextAfterTransition.isExceptionThresholdBreached());
                return locationSpecificHealthContextAfterTransition;
            });
            return isExceptionThresholdBreached.get();
        }

        private void handleSuccess(PartitionKeyRangeWrapper partitionKeyRangeWrapper, RegionalRoutingContext succeededLocation, boolean isReadOnlyRequest) {
            this.locationEndpointToLocationSpecificContextForPartition.compute(succeededLocation, (locationAsKey, locationSpecificContextAsVal) -> {
                if (locationSpecificContextAsVal == null) {
                    locationSpecificContextAsVal = new LocationSpecificHealthContext.Builder().withSuccessCountForWriteForRecovery(0).withExceptionCountForWriteForCircuitBreaking(0).withSuccessCountForReadForRecovery(0).withExceptionCountForReadForCircuitBreaking(0).withUnavailableSince(Instant.MAX).withLocationHealthStatus(LocationHealthStatus.Healthy).withExceptionThresholdBreached(false).build();
                }
                LocationSpecificHealthContext locationSpecificHealthContextAfterTransition = this.locationSpecificHealthContextTransitionHandler.handleSuccess((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.getOrDefault(succeededLocation, ""), false, isReadOnlyRequest);
                if (GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.get(locationAsKey) == null) {
                    GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.put(locationAsKey, GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.globalEndpointManager.getRegionName(locationAsKey.getGatewayRegionalEndpoint(), isReadOnlyRequest ? OperationType.Read : OperationType.Create));
                }
                String region = (String)GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker.this.regionalRoutingContextToRegion.get(locationAsKey);
                this.regionToLocationSpecificHealthContext.put(region, locationSpecificHealthContextAfterTransition);
                return locationSpecificHealthContextAfterTransition;
            });
        }

        public boolean areLocationsAvailableForPartitionKeyRange(List<RegionalRoutingContext> availableLocationsAtAccountLevel) {
            for (RegionalRoutingContext availableLocation : availableLocationsAtAccountLevel) {
                if (!this.locationEndpointToLocationSpecificContextForPartition.containsKey(availableLocation)) {
                    return true;
                }
                LocationSpecificHealthContext locationSpecificHealthContextSnapshot = this.locationEndpointToLocationSpecificContextForPartition.get(availableLocation);
                if (!locationSpecificHealthContextSnapshot.isRegionAvailableToProcessRequests()) continue;
                return true;
            }
            return false;
        }
    }
}

