/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.PartitionKey;
import java.util.List;

public final class SinglePartitionKeyServerBatchRequest
extends ServerBatchRequest {
    private final PartitionKey partitionKey;

    private SinglePartitionKeyServerBatchRequest(PartitionKey partitionKey) {
        super(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.partitionKey = partitionKey;
    }

    static SinglePartitionKeyServerBatchRequest createBatchRequest(PartitionKey partitionKey, List<CosmosItemOperation> operations, CosmosItemSerializer effectiveItemSerializer) {
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(operations, "expected non-null operations");
        SinglePartitionKeyServerBatchRequest request = new SinglePartitionKeyServerBatchRequest(partitionKey);
        request.createBodyOfBatchRequest(operations, effectiveItemSerializer);
        return request;
    }

    public PartitionKey getPartitionKeyValue() {
        return this.partitionKey;
    }
}

