/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StaleResourceRetryPolicy
extends DocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(StaleResourceRetryPolicy.class);
    private final RxCollectionCache clientCollectionCache;
    private final DocumentClientRetryPolicy nextPolicy;
    private final String collectionLink;
    private final Map<String, Object> requestOptionProperties;
    private final AtomicBoolean shouldSuppressRetry;
    private final ISessionContainer sessionContainer;
    private RxDocumentServiceRequest request;
    private final DiagnosticsClientContext diagnosticsClientContext;
    private final AtomicReference<CosmosDiagnostics> cosmosDiagnosticsHolder;
    private volatile boolean retried = false;

    public StaleResourceRetryPolicy(RxCollectionCache collectionCache, DocumentClientRetryPolicy nextPolicy, String resourceFullName, Map<String, Object> requestOptionProperties, Map<String, String> requestCustomHeaders, ISessionContainer sessionContainer, DiagnosticsClientContext diagnosticsClientContext) {
        this.clientCollectionCache = collectionCache;
        this.nextPolicy = nextPolicy;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.requestOptionProperties = requestOptionProperties;
        this.shouldSuppressRetry = new AtomicBoolean(this.shouldSuppressRetry(requestCustomHeaders));
        this.sessionContainer = sessionContainer;
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.cosmosDiagnosticsHolder = new AtomicReference<Object>(null);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        if (this.nextPolicy != null) {
            this.nextPolicy.onBeforeSendRequest(request);
        }
    }

    @Override
    public RetryContext getRetryContext() {
        if (this.nextPolicy != null) {
            return this.nextPolicy.getRetryContext();
        }
        return null;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        CosmosException clientException = Utils.as(e, CosmosException.class);
        if (this.isServerNameCacheStaledException(clientException) || this.isGatewayStaledContainerException(clientException)) {
            if (!this.retried) {
                AtomicReference oldCollectionRid = new AtomicReference();
                return this.clientCollectionCache.resolveByNameAsync(this.getMetadataDiagnosticsContext(), this.collectionLink, this.requestOptionProperties).flatMap(collectionInCache -> {
                    oldCollectionRid.set(collectionInCache.getResourceId());
                    if (this.request == null || this.request.requestContext == null || StringUtils.equals(collectionInCache.getResourceId(), this.request.requestContext.resolvedCollectionRid)) {
                        this.clientCollectionCache.refresh(this.getMetadataDiagnosticsContext(), this.collectionLink, this.requestOptionProperties);
                        return this.clientCollectionCache.resolveByNameAsync(this.getMetadataDiagnosticsContext(), this.collectionLink, this.requestOptionProperties).map(Resource::getResourceId);
                    }
                    return Mono.just((Object)((String)oldCollectionRid.get()));
                }).flatMap(refreshedCollectionRid -> {
                    if (!StringUtils.equals(refreshedCollectionRid, (CharSequence)oldCollectionRid.get())) {
                        this.sessionContainer.clearTokenByResourceId((String)oldCollectionRid.get());
                    }
                    this.retried = true;
                    if (this.shouldSuppressRetry.get()) {
                        return Mono.just((Object)ShouldRetryResult.error(e));
                    }
                    return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ZERO));
                });
            }
            logger.warn("Received second {} after backoff/retry. Will fail the request. {}", (Object)((Object)((Object)clientException)).getClass().getSimpleName(), (Object)clientException.toString());
            if (this.isServerNameCacheStaledException(clientException)) {
                return Mono.just((Object)ShouldRetryResult.error((Exception)((Object)BridgeInternal.createServiceUnavailableException((Exception)((Object)clientException), 21001))));
            }
            return Mono.just((Object)ShouldRetryResult.error(e));
        }
        if (this.nextPolicy != null) {
            return this.nextPolicy.shouldRetry(e);
        }
        return Mono.just((Object)ShouldRetryResult.error(e));
    }

    private MetadataDiagnosticsContext getMetadataDiagnosticsContext() {
        if (this.request != null) {
            return BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics);
        }
        if (this.cosmosDiagnosticsHolder.get() == null) {
            this.cosmosDiagnosticsHolder.set(this.diagnosticsClientContext.createDiagnostics());
        }
        return BridgeInternal.getMetaDataDiagnosticContext(this.cosmosDiagnosticsHolder.get());
    }

    private boolean isServerNameCacheStaledException(CosmosException cosmosException) {
        return cosmosException != null && Exceptions.isStatusCode(cosmosException, 410) && Exceptions.isSubStatusCode(cosmosException, 1000);
    }

    private boolean isGatewayStaledContainerException(CosmosException cosmosException) {
        return cosmosException != null && Exceptions.isStatusCode(cosmosException, 400) && Exceptions.isSubStatusCode(cosmosException, 1024);
    }

    private boolean shouldSuppressRetry(Map<String, String> requestCustomHeaders) {
        if (requestCustomHeaders == null) {
            return false;
        }
        return StringUtils.isNotEmpty(requestCustomHeaders.get("x-ms-cosmos-intended-collection-rid"));
    }
}

