/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.CosmosFullTextPath;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Beta(value=Beta.SinceVersion.V4_65_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosFullTextPolicy {
    @JsonProperty(value="defaultLanguage")
    private String defaultLanguage;
    @JsonProperty(value="fullTextPaths")
    private List<CosmosFullTextPath> paths;

    @Beta(value=Beta.SinceVersion.V4_65_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosFullTextPolicy() {
    }

    @Beta(value=Beta.SinceVersion.V4_65_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Beta(value=Beta.SinceVersion.V4_65_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosFullTextPolicy setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_65_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public List<CosmosFullTextPath> getPaths() {
        return this.paths;
    }

    @Beta(value=Beta.SinceVersion.V4_65_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosFullTextPolicy setPaths(List<CosmosFullTextPath> paths) {
        for (CosmosFullTextPath cosmosFullTextPath : paths) {
            if (!cosmosFullTextPath.getLanguage().isEmpty()) continue;
            throw new IllegalArgumentException("Language needs to specified for the path in the Full text policy.");
        }
        this.paths = paths;
        return this;
    }
}

