/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.apachecommons.math.distribution;

import com.azure.cosmos.implementation.apachecommons.math.distribution.AbstractIntegerDistribution;
import com.azure.cosmos.implementation.apachecommons.math.distribution.SaddlePointExpansion;
import com.azure.cosmos.implementation.apachecommons.math.exception.NotPositiveException;
import com.azure.cosmos.implementation.apachecommons.math.exception.OutOfRangeException;
import com.azure.cosmos.implementation.apachecommons.math.exception.util.Localizable;
import com.azure.cosmos.implementation.apachecommons.math.exception.util.LocalizedFormats;
import com.azure.cosmos.implementation.apachecommons.math.random.RandomGenerator;
import com.azure.cosmos.implementation.apachecommons.math.random.Well19937c;
import com.azure.cosmos.implementation.apachecommons.math.special.Beta;
import com.azure.cosmos.implementation.apachecommons.math.util.FastMath;

public class BinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int trials, double p) {
        this(new Well19937c(), trials, p);
    }

    public BinomialDistribution(RandomGenerator rng, int trials, double p) {
        super(rng);
        if (trials < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, trials);
        }
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        this.probabilityOfSuccess = p;
        this.numberOfTrials = trials;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        if (this.numberOfTrials == 0) {
            return x == 0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        double ret = x < 0 || x > this.numberOfTrials ? Double.NEGATIVE_INFINITY : SaddlePointExpansion.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        double ret = x < 0 ? 0.0 : (x >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.probabilityOfSuccess, (double)x + 1.0, this.numberOfTrials - x));
        return ret;
    }

    @Override
    public double getNumericalMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    @Override
    public double getNumericalVariance() {
        double p = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * p * (1.0 - p);
    }

    @Override
    public int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

