/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.UserAgentFeatureFlags;
import com.azure.cosmos.implementation.Utils;
import java.text.Normalizer;
import java.util.Set;
import java.util.regex.Pattern;

public class UserAgentContainer {
    private static final Pattern nonASCII = Pattern.compile("[^\\x00-\\x7f]");
    private static final Pattern markers = Pattern.compile("\\p{M}");
    private static final int MAX_USER_AGENT_LENGTH = 255;
    private final int maxSuffixLength;
    private final String baseUserAgent;
    private String suffix;
    private String userAgent;
    public static final String AZSDK_USERAGENT_PREFIX = "azsdk-java-";

    private UserAgentContainer(String sdkName, String sdkVersion) {
        this.baseUserAgent = Utils.getUserAgent(sdkName, sdkVersion);
        this.suffix = "";
        this.userAgent = this.baseUserAgent;
        this.maxSuffixLength = 254 - this.baseUserAgent.length();
    }

    public UserAgentContainer() {
        this("cosmos", HttpConstants.Versions.getSdkVersion());
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setFeatureEnabledFlagsAsSuffix(Set<UserAgentFeatureFlags> userAgentFeatureFlags) {
        if (userAgentFeatureFlags == null || userAgentFeatureFlags.isEmpty()) {
            return;
        }
        int value = 0;
        for (UserAgentFeatureFlags userAgentFeatureFlag : userAgentFeatureFlags) {
            value += userAgentFeatureFlag.getValue();
        }
        this.userAgent = this.userAgent + "|F" + value;
    }

    public void setSuffix(String suffix) {
        if (suffix.length() > this.maxSuffixLength) {
            suffix = suffix.substring(0, this.maxSuffixLength);
        }
        this.suffix = suffix;
        this.userAgent = UserAgentContainer.stripNonAsciiCharacters(this.baseUserAgent.concat(" ").concat(this.suffix));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    private static String stripNonAsciiCharacters(String input) {
        String normalized = input == null ? null : Normalizer.normalize(input, Normalizer.Form.NFKD);
        String strippedMarkers = markers.matcher(normalized).replaceAll("");
        return nonASCII.matcher(strippedMarkers).replaceAll("_");
    }
}

