/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.BatchExecUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.Map;

public final class CosmosBulkItemResponse {
    private final String eTag;
    private final double requestCharge;
    private ObjectNode resourceObject;
    private final int statusCode;
    private final Duration retryAfter;
    private final int subStatusCode;
    private final Map<String, String> responseHeaders;
    private final CosmosDiagnostics cosmosDiagnostics;
    private CosmosItemSerializer effectiveItemSerializer;

    CosmosBulkItemResponse(String eTag, double requestCharge, ObjectNode resourceObject, int statusCode, Duration retryAfter, int subStatusCode, Map<String, String> responseHeaders, CosmosDiagnostics cosmosDiagnostics, CosmosItemSerializer effectiveItemSerializer) {
        Preconditions.checkNotNull(responseHeaders, "expected non-null responseHeaders");
        this.eTag = eTag;
        this.requestCharge = requestCharge;
        this.resourceObject = resourceObject;
        this.statusCode = statusCode;
        this.retryAfter = retryAfter;
        this.subStatusCode = subStatusCode;
        this.responseHeaders = responseHeaders;
        this.cosmosDiagnostics = cosmosDiagnostics;
        this.effectiveItemSerializer = effectiveItemSerializer;
    }

    public String getActivityId() {
        return BatchExecUtils.getActivityId(this.responseHeaders);
    }

    public String getETag() {
        return this.eTag;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public <T> T getItem(Class<T> type) {
        T item = null;
        if (this.getResourceObject() != null) {
            item = this.effectiveItemSerializer == CosmosItemSerializer.DEFAULT_SERIALIZER ? (T)new JsonSerializable(this.getResourceObject()).toObject(type) : (T)Utils.parse(this.getResourceObject(), type, this.effectiveItemSerializer);
        }
        return item;
    }

    public Duration getRetryAfterDuration() {
        return this.retryAfter;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public boolean isSuccessStatusCode() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public CosmosDiagnostics getCosmosDiagnostics() {
        return this.cosmosDiagnostics;
    }

    public String getSessionToken() {
        return BatchExecUtils.getSessionToken(this.responseHeaders);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Duration getDuration() {
        if (this.cosmosDiagnostics == null) {
            return Duration.ZERO;
        }
        return this.cosmosDiagnostics.getDuration();
    }

    private ObjectNode getResourceObject() {
        return this.resourceObject;
    }

    void setEffectiveItemSerializer(CosmosItemSerializer effectiveItemSerializer) {
        this.effectiveItemSerializer = effectiveItemSerializer;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBulkItemResponseHelper.setCosmosBulkItemResponseAccessor(new ImplementationBridgeHelpers.CosmosBulkItemResponseHelper.CosmosBulkItemResponseAccessor(){

            @Override
            public ObjectNode getResourceObject(CosmosBulkItemResponse cosmosBulkItemResponse) {
                return cosmosBulkItemResponse.getResourceObject();
            }

            @Override
            public void setResourceObject(CosmosBulkItemResponse cosmosBulkItemResponse, ObjectNode objectNode) {
                cosmosBulkItemResponse.resourceObject = objectNode;
            }

            @Override
            public void setEffectiveItemSerializer(CosmosBulkItemResponse cosmosBulkItemResponse, CosmosItemSerializer effectiveItemSerializer) {
                cosmosBulkItemResponse.setEffectiveItemSerializer(effectiveItemSerializer);
            }
        });
    }

    static {
        CosmosBulkItemResponse.initialize();
    }
}

