/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.controller.group.global;

import java.time.Duration;
import java.time.Instant;

public class ThroughputUsageSnapshot {
    private final double throughputUsage;
    private final Instant time;
    private double weight;

    public ThroughputUsageSnapshot(double throughputUsage) {
        this.throughputUsage = throughputUsage;
        this.time = Instant.now();
    }

    public double getThroughputUsage() {
        return this.throughputUsage;
    }

    public Instant getTime() {
        return this.time;
    }

    public double getWeight() {
        return this.weight;
    }

    public double calculateWeight(Instant startTime) {
        this.weight = Math.exp(Duration.between(this.time, startTime).getSeconds());
        return this.weight;
    }
}

